from rest_framework import serializers

from applications.users.models import User


class SearchUserSerializer(serializers.ModelSerializer):
    code_melli = serializers.SerializerMethodField()

    class Meta:
        model = User
        fields = ("id", "first_name", "last_name", "code_melli", "mobile_number", "father", "shomare_shenasname",
                  "address", "sadere", "phone_number", "code_posti")

    def get_code_melli(self, user):
        return user.username


class UserInGholnameSerializer(serializers.ModelSerializer):
    code_melli = serializers.SerializerMethodField()

    class Meta:
        model = User
        fields = ("first_name", "last_name", "father", "shomare_shenasname", "username", "sadere", "phone_number",
                  "mobile_number", "code_posti", "address", "id", 'code_melli')

    def get_code_melli(self, user):
        return user.username


class UserInGholnameListSerializer(serializers.ModelSerializer):
    code_melli = serializers.SerializerMethodField()

    class Meta:
        model = User
        fields = ("id", "first_name", "last_name", "father", "code_melli")

    def get_code_melli(self, user):
        return user.username
