from rest_framework import serializers

from applications.cars.serializers import CarInFaskhGholnameSerializer, CarInGholnameListSerializer
from applications.gholname.models import Gholname, Ghest, Faskh
from applications.users.serializers import UserInGholnameSerializer, UserInGholnameListSerializer


class GholnameSerializer(serializers.ModelSerializer):
    foro0shande = UserInGholnameSerializer()
    kharidar = UserInGholnameSerializer()
    faskh_info = serializers.SerializerMethodField()
    type = serializers.SerializerMethodField()

    class Meta:
        model = Gholname
        fields = ("id", "foro0shande", "kharidar", "shomare_sanad", "datetime", "dong", "total_cost", "pish_pardakht",
                  "kharj_sanad", "tahvil_datetime", "description", "shomare_dasti", "faskh_info", "type", "main_cost")

    def get_type(self, gholname):
        return gholname.get_type()

    def get_faskh_info(self, gholname):
        try:
            faskh = gholname.faskh
            return FaskhSerializer(faskh).data
        except AttributeError:
            return None


class GhestSerializer(serializers.ModelSerializer):

    class Meta:
        model = Ghest
        fields = ("date", "amount", "status", "tasvie_kamel")

class FaskhGholnameSerializer(serializers.ModelSerializer):
    car = CarInFaskhGholnameSerializer()
    name = serializers.SerializerMethodField()
    father = serializers.SerializerMethodField()
    type = serializers.SerializerMethodField()

    class Meta:
        model = Gholname
        fields = ("id", "name", "father", "type", "car", "datetime", "tahvil_datetime")

    def get_name(self, gholname):
        gholname_type = gholname.get_type()
        if gholname_type == "kharid_namayeshgah":
            return gholname.foro0shande.get_full_name()
        elif gholname_type in ["naghdi", "aghsati"]:
            return gholname.kharidar.get_full_name()
        else:
            return None

    def get_father(self, gholname):
        gholname_type = gholname.get_type()
        if gholname_type == "kharid_namayeshgah":
            return gholname.foro0shande.father
        elif gholname_type in ["naghdi", "aghsati"]:
            return gholname.kharidar.father
        else:
            return None

    def get_type(self, gholname):
        return gholname.get_type()


class GholnameListSerializer(serializers.ModelSerializer):
    car = CarInGholnameListSerializer()
    kharidar = UserInGholnameListSerializer()
    foro0shande = UserInGholnameListSerializer()
    type = serializers.SerializerMethodField()
    is_faskh = serializers.SerializerMethodField()
    foro0sh_type = serializers.SerializerMethodField()
    foro0sh_id = serializers.SerializerMethodField()

    class Meta:
        model = Gholname
        fields = ("id", "shomare_sanad", "kharidar", "foro0shande", "type", "car", "shomare_dasti", "is_faskh",
                  "foro0sh_type", "foro0sh_id")

    def get_type(self, gholname):
        if gholname.is_sefr and self.get_foro0sh_type(gholname) is not None:
            return self.get_foro0sh_type(gholname)
        return gholname.get_type()

    def get_foro0sh_type(self, gholname):
        if gholname.get_type() == "kharid_namayeshgah":
            try:
                gholname_foro0sh = gholname.kharid.gholname_foro0sh
                return gholname_foro0sh.get_type()
            except AttributeError:
                return None
        return None

    def get_is_faskh(self, gholname):
        return hasattr(gholname, "faskh")

    def get_foro0sh_id(self, gholname):
        if gholname.get_type() == "kharid_namayeshgah" and gholname.is_sefr:
            try:
                gholname_foro0sh = gholname.kharid.gholname_foro0sh
                return gholname_foro0sh.id
            except AttributeError:
                return None
        return None


class FaskhSerializer(serializers.ModelSerializer):

    class Meta:
        model = Faskh
        fields = ["faskh_datetime", "sabt_datetime", "description"]
