# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.contrib import admin

# Register your models here.
from applications.gholname.models import Gholname, KharidNamayeshgahGholname, NaghdiGholname, AghsatiGholname, Ghest, \
    Faskh, LizingGholname


@admin.register(Gholname)
class GholnameAdmin(admin.ModelAdmin):
    list_display = ["id", "shomare_sanad", "datetime", "car", "tahvil_datetime", "total_cost", "pish_pardakht", "kharj_sanad",
                    "dong", "kharidar", "foro0shande"]


@admin.register(AghsatiGholname)
class AghsatiGholnameAdmin(admin.ModelAdmin):
    list_display = ["id", "gholname", "num_of_ghest", "percent", "ghest_start_datetime"]


admin.site.register(KharidNamayeshgahGholname)
admin.site.register(NaghdiGholname)


@admin.register(Ghest)
class GhestAdmin(admin.ModelAdmin):
    list_display = ["get_gholname_aghsati", "date", "amount", "status", "tasvie_kamel"]

    def get_gholname_aghsati(self, obj):
        return obj.gholname_aghsati.gholname.shomare_sanad

    get_gholname_aghsati.short_description = "Shomare Sanad"
    get_gholname_aghsati.admin_order_field = "gholname_aghsati__gholname__shomare_sanad"


@admin.register(Faskh)
class FaskhAdmin(admin.ModelAdmin):
    list_display = ["gholname", "faskh_datetime", "sabt_datetime", "description"]


@admin.register(LizingGholname)
class LizingGholnameAdmin(admin.ModelAdmin):
    list_display = ["id", "gholname", "chek_num", "moddat_chek"]

