# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.contrib import admin

from applications.cars.models import Car, CarCost, CarType, CarSystem, CarTip, Color


@admin.register(Car)
class CarAdmin(admin.ModelAdmin):
    list_display = ["id", "name", "system", "tip", "model", "color", "pelak", "shasi", "motor", "code", "vin",
                    "saheb_pelak", "is_deleted"]


@admin.register(CarCost)
class CarCostAdmin(admin.ModelAdmin):
    list_display = ["subject", "amount", "store", "description"]


admin.site.register(CarType)
admin.site.register(CarSystem)
admin.site.register(CarTip)
admin.site.register(Color)
