# -*- coding: utf-8 -*-
# Generated by Django 1.11 on 2018-12-03 06:25
from __future__ import unicode_literals

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('accounting', '0004_auto_20181121_1046'),
    ]

    operations = [
        migrations.CreateModel(
            name='BankTransfer',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('sabt_date', models.DateField()),
                ('amal_date', models.DateField()),
                ('mablagh', models.BigIntegerField()),
                ('karmozd', models.BigIntegerField()),
                ('tarigh', models.SmallIntegerField(choices=[(0, '\u067e\u0632'), (1, '\u0646\u0642\u062f\u0627'), (2, '\u06a9\u0627\u0631\u062a \u0628\u0647 \u06a9\u0627\u0631\u062a'), (3, '\u0686\u06a9 \u0628\u0627\u0646\u06a9\u06cc'), (4, '\u062d\u0648\u0627\u0644\u0647'), (5, '\u0686\u06a9')])),
                ('bAbat', models.CharField(max_length=256)),
                ('tozihat', models.TextField(default='')),
                ('by', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
                ('mabda_bank', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='mabda_bank', to='accounting.Bank')),
                ('maghsad_bank', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='maghsad_bank', to='accounting.Bank')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='Calendar',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('date', models.DateField()),
                ('title', models.CharField(max_length=128)),
                ('body', models.TextField(default='')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='ChekStatusDelay',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('tozihat', models.TextField(default='')),
                ('date', models.DateField()),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='ChekStatusDelete',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('tozihat', models.TextField(default='')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='ChekStatusPass',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('tozihat', models.TextField(default='')),
                ('date', models.DateField()),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='ChekStatusReturn',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('tozihat', models.TextField(default='')),
                ('date', models.DateField()),
                ('kar_mozd', models.BigIntegerField(default=0)),
                ('bank', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to='accounting.Bank')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='ChekStatusVosul',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('tozihat', models.TextField(default='')),
                ('date', models.DateField()),
                ('kar_mozd', models.BigIntegerField(default=0)),
                ('bank', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='accounting.Bank')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='PardakhtBeTarafHesab',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('tarikh_pardakht', models.DateField()),
                ('jahat', models.CharField(choices=[('FORUSH_KHODRO', '\u0641\u0631\u0648\u0634 \u062e\u0648\u062f\u0631\u0648'), ('HESAB_DAFTARI', '\u062d\u0633\u0627\u0628 \u062f\u0641\u062a\u0631\u06cc'), ('DAFTAR_KOL', '\u062f\u0641\u062a\u0631 \u06a9\u0644'), ('ESLAHIE_HESAB_DAFTARI', '\u0627\u0635\u0644\u0627\u062d\u06cc\u0647 \u062d\u0633\u0627\u0628 \u062f\u0641\u062a\u0631\u06cc'), ('ESLAHIE_DAFTAR_KOL', '\u0627\u0635\u0644\u0627\u062d\u06cc\u0647 \u062f\u0641\u062a\u0631 \u06a9\u0644'), ('FAGHAT_HESAB_DAFTARI', '\u0641\u0642\u0637 \u062d\u0633\u0627\u0628 \u062f\u0641\u062a\u0631\u06cc')], max_length=100)),
                ('bAbat', models.CharField(blank=True, max_length=256, null=True)),
                ('tozihat', models.TextField(blank=True, default='', null=True)),
                ('pos_amount', models.PositiveIntegerField(default=0)),
                ('card_amount', models.PositiveIntegerField(default=0)),
                ('cash', models.PositiveIntegerField(default=0)),
                ('card', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='accounting.Card')),
                ('daftar_kol', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='accounting.DaftarKol')),
                ('daryaft_konande', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='daryaft_konande_taraf_hesabs', to=settings.AUTH_USER_MODEL)),
                ('pos', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='accounting.Pos')),
                ('tavassot', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='tavasot_daryaft_taraf_hesabs', to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.RemoveField(
            model_name='daryaftaztarafhesabchek',
            name='chek',
        ),
        migrations.RemoveField(
            model_name='daryaftaztarafhesabchek',
            name='daryaft_at_taraf_hesab',
        ),
        migrations.AddField(
            model_name='chek',
            name='daryafti',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to='accounting.DaryaftAzTarafHesab'),
        ),
        migrations.AddField(
            model_name='chek',
            name='is_self',
            field=models.BigIntegerField(default=None),
            preserve_default=False,
        ),
        migrations.AddField(
            model_name='chek',
            name='tarikh_pardakht',
            field=models.DateField(null=True),
        ),
        migrations.DeleteModel(
            name='DaryaftAzTarafHesabChek',
        ),
        migrations.AddField(
            model_name='chekstatusvosul',
            name='chek',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='accounting.Chek'),
        ),
        migrations.AddField(
            model_name='chekstatusreturn',
            name='chek',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='accounting.Chek'),
        ),
        migrations.AddField(
            model_name='chekstatuspass',
            name='chek',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='accounting.Chek'),
        ),
        migrations.AddField(
            model_name='chekstatusdelete',
            name='chek',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='accounting.Chek'),
        ),
        migrations.AddField(
            model_name='chekstatusdelay',
            name='chek',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='accounting.Chek'),
        ),
        migrations.AddField(
            model_name='calendar',
            name='chek',
            field=models.OneToOneField(null=True, on_delete=django.db.models.deletion.CASCADE, to='accounting.Chek'),
        ),
        migrations.AddField(
            model_name='chek',
            name='pardakhti',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to='accounting.PardakhtBeTarafHesab'),
        ),
    ]
