# -*- coding: utf-8 -*-
# Generated by Django 1.11 on 2018-09-24 15:39
from __future__ import unicode_literals

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='Bank',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=70)),
            ],
        ),
        migrations.CreateModel(
            name='Cart',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('uuid', models.CharField(max_length=128)),
                ('name', models.CharField(max_length=128)),
            ],
        ),
        migrations.CreateModel(
            name='Chek',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('tarikh_sarresid', models.DateField()),
                ('shomare_chek', models.CharField(max_length=30)),
                ('dar_vajh', models.CharField(blank=True, max_length=128, null=True)),
                ('code', models.CharField(blank=True, max_length=20, null=True)),
                ('shobe', models.CharField(blank=True, max_length=64, null=True)),
                ('shomare_hesab', models.CharField(blank=True, max_length=64, null=True)),
                ('saheb_hesab', models.CharField(max_length=64)),
                ('mablagh', models.PositiveIntegerField()),
                ('bank', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='accounting.Bank')),
            ],
        ),
        migrations.CreateModel(
            name='DaftarKol',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=128)),
            ],
        ),
        migrations.CreateModel(
            name='DaryaftAzTarafHesab',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('tarikh_daryaft', models.DateField()),
                ('jahat', models.CharField(choices=[('KHARID_KHODRO', '\u062e\u0631\u06cc\u062f \u062e\u0648\u062f\u0631\u0648'), ('HESAB_DAFTARI', '\u062d\u0633\u0627\u0628 \u062f\u0641\u062a\u0631\u06cc'), ('DAFTAR_KOL', '\u062f\u0641\u062a\u0631 \u06a9\u0644'), ('ESLAHIE_HESAB_DAFTARI', '\u0627\u0635\u0644\u0627\u062d\u06cc\u0647 \u062d\u0633\u0627\u0628 \u062f\u0641\u062a\u0631\u06cc'), ('ESLAHIE_DAFTAR_KOL', '\u0627\u0635\u0644\u0627\u062d\u06cc\u0647 \u062f\u0641\u062a\u0631 \u06a9\u0644'), ('FAGHAT_HESAB_DAFTARI', '\u0641\u0642\u0637 \u062d\u0633\u0627\u0628 \u062f\u0641\u062a\u0631\u06cc')], max_length=100)),
                ('bAbat', models.CharField(blank=True, max_length=256, null=True)),
                ('tozihat', models.TextField(blank=True, default='', null=True)),
                ('pos_amount', models.PositiveIntegerField(default=0)),
                ('cart_amount', models.PositiveIntegerField(default=0)),
                ('cash', models.PositiveIntegerField(default=0)),
                ('cart', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='accounting.Cart')),
                ('daftar_kol', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='accounting.DaftarKol')),
                ('pardakht_konande', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='pardakht_konande_taraf_hesabs', to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='DaryaftAzTarafHesabChek',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('chek', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='accounting.Chek')),
                ('daryaft_at_taraf_hesab', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='accounting.DaryaftAzTarafHesab')),
            ],
        ),
        migrations.CreateModel(
            name='Pos',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('uuid', models.CharField(max_length=128)),
                ('name', models.CharField(max_length=128)),
                ('daftar_kol', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='accounting.DaftarKol')),
            ],
        ),
        migrations.AddField(
            model_name='daryaftaztarafhesab',
            name='pos',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='accounting.Pos'),
        ),
        migrations.AddField(
            model_name='daryaftaztarafhesab',
            name='tavassot',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='tavasot_pardakht_taraf_hesabs', to=settings.AUTH_USER_MODEL),
        ),
        migrations.AddField(
            model_name='cart',
            name='daftar_kol',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='accounting.DaftarKol'),
        ),
    ]
