# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.contrib.auth.models import AbstractUser
from django.db import models


class User(AbstractUser):
    mobile_number = models.CharField(max_length=11, default="")
    address = models.TextField(default="", null=True, blank=True)
    father = models.CharField(default="", max_length=64)
    shomare_shenasname = models.CharField(default="", max_length=15)
    sadere = models.CharField(default="", max_length=64)
    phone_number = models.CharField(max_length=11, default="")
    code_posti = models.CharField(default="", max_length=25)
    is_admin = models.BooleanField(default=False)
    is_store = models.BooleanField(default=False)

    def __str__(self):
        return self.ssn_number

    @property
    def get_fullname(self):
        return self.get_full_name()

    def update(self, first_name=None, last_name=None, mobile_number=None, address=None, father=None,
               shomare_shenasname=None, sadere=None, phone_number=None, code_posti=None):
        if first_name is not None:
            self.first_name = first_name
        if last_name is not None:
            self.last_name = last_name
        if mobile_number is not None:
            self.mobile_number = mobile_number
        if address is not None:
            self.address = address
        if father is not None:
            self.father = father
        if shomare_shenasname is not None:
            self.shomare_shenasname = shomare_shenasname
        if sadere is not None:
            self.sadere = sadere
        if phone_number is not None:
            self.phone_number = phone_number
        if code_posti is not None:
            self.code_posti = code_posti

        self.save()
