# -*- coding: utf-8 -*-
from __future__ import unicode_literals

import jdatetime
from django.db import models
# Create your models here.
from django.utils import timezone

from applications.cars.models import Car
from applications.users.models import User
from applications.utilities.models import TimeStampedModel


class Gholname(TimeStampedModel):
    shomare_sanad = models.BigIntegerField(default=10000)  # unique=True
    car = models.ForeignKey(to=Car, on_delete=models.CASCADE)
    description = models.TextField(default="", null=True, blank=True)
    datetime = models.DateTimeField(default=timezone.now)
    tahvil_datetime = models.DateTimeField(default=timezone.now)
    total_cost = models.BigIntegerField(default=0)
    pish_pardakht = models.BigIntegerField(default=0)
    kharj_sanad = models.BigIntegerField(default=0)
    dong = models.CharField(default="", max_length=32)
    shomare_dasti = models.BigIntegerField(default=0)
    sharayet = models.TextField(
        default="")  # TODO: baadan in tamiz she, sharayet e gozashte ro to0 yek model negah dAre va F.K bezan besh
    is_sefr = models.BooleanField(default=False)
    main_cost = models.PositiveIntegerField(default=0)

    kharidar = models.ForeignKey(
        to=User,
        on_delete=models.PROTECT,
        null=True,
        blank=True,
        related_name="kharidar"
    )

    foro0shande = models.ForeignKey(
        to=User,
        on_delete=models.PROTECT,
        null=True,
        blank=True,
        related_name="foro0shande"
    )

    def __str__(self):
        return str(self.shomare_sanad)

    def get_type(self):
        if hasattr(self, "kharidnamayeshgahgholname"):
            return "kharid_namayeshgah"
        elif hasattr(self, "naghdigholname"):
            return "sefr_naghdi" if self.is_sefr else "naghdi"
        elif hasattr(self, "aghsatigholname"):
            return "sefr_aghsati" if self.is_sefr else "aghsati"
        elif hasattr(self, "lizinggholname"):
            return "sefr_lizing"
        else:
            return None

    def update(self, description=None, kharidar=None, foro0shande=None, datetime=None, car=None, tahvil_datetime=None,
               total_cost=None, pish_pardakht=None, kharj_sanad=None, dong=None, sharayet=None, shomare_dasti=None):
        if description is not None:
            self.description = description

        if kharidar is not None:
            self.kharidar = kharidar

        if foro0shande is not None:
            self.foro0shande = foro0shande

        if datetime is not None:
            self.datetime = datetime

        if car is not None:
            if self.car:
                self.car.is_in_parking = True
                self.car.save()
            self.car = car
            self.car.is_in_parking = False
            self.car.save()

        if tahvil_datetime is not None:
            self.tahvil_datetime = tahvil_datetime

        if total_cost is not None:
            self.total_cost = total_cost

        if pish_pardakht is not None:
            self.pish_pardakht = pish_pardakht

        if kharj_sanad is not None:
            self.kharj_sanad = kharj_sanad

        if dong is not None:
            self.dong = dong

        if sharayet is not None:
            self.sharayet = sharayet

        if shomare_dasti is not None:
            self.shomare_dasti = shomare_dasti

        if (description or kharidar or foro0shande or datetime or car or tahvil_datetime or total_cost or
                pish_pardakht or kharj_sanad or dong or sharayet or shomare_dasti):
            self.save()


class KharidNamayeshgahGholname(models.Model):
    gholname = models.OneToOneField(to=Gholname)


class NaghdiGholname(models.Model):
    gholname = models.OneToOneField(to=Gholname)


class AghsatiGholname(models.Model):
    gholname = models.OneToOneField(to=Gholname, null=True)
    num_of_ghest = models.IntegerField(default=0)
    percent = models.FloatField(default=0.0)
    ghest_start_datetime = models.DateTimeField(default=timezone.now)

    def calculate_ghest_cost(self):
        z = self.num_of_ghest

        return int(float(self.calculate_with_so0d()) / float(z))

    def calculate_with_so0d(self):
        x = self.gholname.total_cost - self.gholname.pish_pardakht  # bAghimAnde
        y = self.percent
        z = self.num_of_ghest

        if y < 5:
            return int(float(x) * float(y * z + 100) / 100.0)
        else:
            return int(float(x) * float(y * (z + 1) + 200) / 200.0)

    def create_aghsats(self):
        ghest_cost = self.calculate_ghest_cost()
        # remained_cost = self.calculate_with_so0d()
        datetime = self.ghest_start_datetime
        jdate = jdatetime.date.fromgregorian(date=datetime)
        for i in range(0, self.num_of_ghest):
            try:
                date = jdatetime.date(jdate.year + (jdate.month + i - 1) / 12, (jdate.month + i - 1) % 12 + 1,
                                      jdate.day).togregorian()
            except ValueError:
                date = jdatetime.date(jdate.year + (jdate.month + i - 1) / 12, (jdate.month + i - 1) % 12 + 1,
                                      jdate.day - 1).togregorian()
            Ghest.objects.create(
                gholname_aghsati=self,
                amount=ghest_cost,
                date=date,
                tasvie_kamel=self.calculate_tasvie_kAmel(month_number=i + 1)
            )

    def update(self, num_of_ghest=None, percent=None, ghest_start_datetime=None):
        if num_of_ghest:
            self.num_of_ghest = num_of_ghest

        if percent:
            self.percent = percent

        if ghest_start_datetime:
            self.ghest_start_datetime = ghest_start_datetime

        if num_of_ghest or percent or ghest_start_datetime:
            self.ghest_set.all().delete()
            self.save()
            self.create_aghsats()

    def calculate_tasvie_kAmel(self, month_number):
        z = float(self.num_of_ghest - month_number)
        a = float(self.calculate_ghest_cost())
        y = float(self.percent)
        return int(100.0 * a * z / ((y - 0.5) * z + 100.0))


class Ghest(models.Model):
    gholname_aghsati = models.ForeignKey(AghsatiGholname, on_delete=models.CASCADE, null=True)
    date = models.DateField(default=timezone.now)
    amount = models.BigIntegerField(default=0)
    status = models.CharField(default="", max_length=256)
    tasvie_kamel = models.BigIntegerField(default=0)


class Faskh(models.Model):
    gholname = models.OneToOneField(Gholname, on_delete=models.CASCADE, null=True)
    faskh_datetime = models.DateTimeField(default=timezone.now)
    sabt_datetime = models.DateTimeField(default=timezone.now)
    description = models.TextField(default="")

    def __str__(self):
        return str(self.gholname)


class LizingGholname(models.Model):
    gholname = models.OneToOneField(to=Gholname)
    chek_num = models.IntegerField(default=0)
    moddat_chek = models.IntegerField(default=0)

    def update(self, chek_num=None, moddat_chek=None):
        if chek_num is not None:
            self.chek_num = chek_num

        if moddat_chek is not None:
            self.moddat_chek = moddat_chek

        if chek_num is not None or moddat_chek is not None:
            self.save()
