from django.conf.urls import url

from applications.cars.views import (
    CarsView, CarView, CarsHistoryView, CarCostsView, CarTypesView, SystemsView, TipsView, CarColorsView,
    CarSaveView)

app_name = 'cars'

urlpatterns = [
    url(r'^parking/list/$', CarsView.as_view(), name="cars"),
    url(r'^parking/car/(?P<car_id>[0-9]+)/$', CarView.as_view(), name="get_car"),
    url(r'^parking/history/$', CarsHistoryView.as_view(), name="history"),
    url(r'^types/$', CarTypesView.as_view()),
    url(r'^colors/$', CarColorsView.as_view()),
    url(r'^systems/(?P<type_id>[0-9]+)/$', SystemsView.as_view()),
    url(r'^tips/(?P<system_id>[0-9]+)/$', TipsView.as_view()),
    url(r'^systems/undefined/$', SystemsView.as_view()),
    url(r'^tips/undefined/$', TipsView.as_view()),
    url(r'^parking/costs/(?P<id>[0-9]+)/$', CarCostsView.as_view(), name="get_car_costs"),
    url(r'^savecar/$', CarSaveView.as_view())
]
