from rest_framework import serializers

from applications.cars.models import Car, CarCost, CarType, CarSystem, CarTip
from applications.gholname.models import Gholname
from applications.users.serializers import UserInGholnameSerializer


class CarsListSerializer(serializers.ModelSerializer):
    saheb_pelak = UserInGholnameSerializer()

    class Meta:
        model = Car
        fields = (
        "id", "name", "system", "tip", "model", "color", "pelak", "shasi", "motor", "saheb_pelak", "code", "vin")


class CarInFaskhGholnameSerializer(serializers.ModelSerializer):
    class Meta:
        model = Car
        fields = ("id", "name", "model", "color", "pelak")


class CarInGholnameListSerializer(serializers.ModelSerializer):
    class Meta:
        model = Car
        fields = ("id", "name", "system", "tip", "model", "color", "pelak")


class CarsListInParkingSerializer(serializers.ModelSerializer):
    class Meta:
        model = Car
        fields = ("id", "name", "system", "tip", "model", "color", "pelak", "shasi", "motor", "code", "vin")


class GholnameSerializer(serializers.ModelSerializer):
    kharidar = UserInGholnameSerializer()
    foro0shande = UserInGholnameSerializer()

    class Meta:
        model = Gholname
        fields = (
            'kharidar',
            'foro0shande',
        )


class CarsListInParkingExtendedSerializer(serializers.ModelSerializer):
    gholname = GholnameSerializer(source='gholname_set', many=True)

    class Meta:
        model = Car
        fields = ("id", "name", "system", "tip", "model", "color", "pelak", "shasi", "motor", "code", "vin", 'gholname')


class ShowCarSerializer(serializers.ModelSerializer):
    name_id = serializers.SerializerMethodField()
    system_id = serializers.SerializerMethodField()
    tip_id = serializers.SerializerMethodField()

    class Meta:
        model = Car
        fields = (
            "id", "name", "system", "tip", "model", "color", "pelak", "shasi", "motor", "code", "vin", "bime_end_time",
            "takhfif_bime", "kilometer", "moayene_end_time", "fuel", "color_details", "description", "name_id",
            "system_id", "tip_id"
        )

    def get_name_id(self, car):
        # TODO: doros she baadan
        try:
            return CarType.objects.get(name=car.name).id
        except CarType.DoesNotExist:
            return None

    def get_system_id(self, car):
        # TODO: doros she baadan
        try:
            return CarSystem.objects.get(name=car.system).id
        except CarSystem.DoesNotExist:
            return None
        except CarSystem.MultipleObjectsReturned:
            return CarSystem.objects.filter(name=car.system)[0].id

    def get_tip_id(self, car):
        # TODO: doros she baadan
        try:
            return CarTip.objects.get(name=car.tip).id
        except CarTip.DoesNotExist:
            return None


class ShowCarCostSerializer(serializers.ModelSerializer):
    car = ShowCarSerializer()

    class Meta:
        model = CarCost
        fields = '__all__'


class CarInBayganiSerializer(serializers.ModelSerializer):
    class Meta:
        model = Car
        fields = ["name", "model", "shasi", "system"]


class CarInShowBayganiSerializer(serializers.ModelSerializer):
    class Meta:
        model = Car
        fields = ["name", "model", "shasi", "color", "system", "tip"]


class CarTypesListSerializer(serializers.ModelSerializer):
    class Meta:
        model = CarType
        fields = ["id", "name"]


class SystemsListSerializer(serializers.ModelSerializer):
    class Meta:
        model = CarSystem
        fields = ["id", "name"]


class TipsListSerializer(serializers.ModelSerializer):
    class Meta:
        model = CarTip
        fields = ["id", "name"]
