# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.db import models

from django.utils import timezone

from applications.users.models import User
from applications.utilities.models import TimeStampedModel


class Car(TimeStampedModel):
    name = models.CharField(default="", max_length=64)
    system = models.CharField(default="", max_length=64)
    tip = models.CharField(default="", max_length=64)
    model = models.CharField(default="", max_length=64)
    color = models.CharField(default="", max_length=64)
    pelak = models.CharField(default="", max_length=8)
    shasi = models.CharField(default="", max_length=64)
    motor = models.CharField(default="", max_length=64)
    code = models.CharField(default="", max_length=8)
    vin = models.TextField(default="")
    is_deleted = models.BooleanField(default=False)
    is_in_parking = models.BooleanField(default=False)
    bime_end_time = models.DateTimeField(default=timezone.now)
    takhfif_bime = models.IntegerField(default=0)
    kilometer = models.BigIntegerField(default=0)
    moayene_end_time = models.DateTimeField(default=timezone.now)
    fuel = models.IntegerField(default=1)
    color_details = models.CharField(default="00000000000", max_length=11)
    description = models.TextField(default="")

    saheb_pelak = models.ForeignKey(
        to=User,
        on_delete=models.PROTECT,
        null=True,
        blank=True,
        related_name="saheb_pelak"
    )

    def __unicode__(self):
        return self.name

    def update(self, name=None, system=None, tip=None, model=None, color=None, pelak=None, shasi=None, motor=None,
               code=None, vin=None, bime_end_time=None, takhfif_bime=None, kilometer=None, moayene_end_time=None,
               fuel=None, color_details=None, description=None, saheb_pelak=None):
        if name:
            self.name = name
        if system:
            self.system = system
        if tip:
            self.tip = tip
        if model:
            self.model = model
        if color:
            self.color = color
        if pelak:
            self.pelak = pelak
        if shasi:
            self.shasi = shasi
        if motor:
            self.motor = motor
        if code:
            self.code = code
        if vin:
            self.vin = vin
        if bime_end_time:
            self.bime_end_time = bime_end_time
        if takhfif_bime:
            self.takhfif_bime = takhfif_bime
        if kilometer:
            self.kilometer = kilometer
        if moayene_end_time:
            self.moayene_end_time = moayene_end_time
        if fuel:
            self.fuel = fuel
        if color_details:
            self.color_details = color_details
        if description:
            self.description = description
        if saheb_pelak:
            self.saheb_pelak = saheb_pelak


        if (
                name is not None or system is not None or tip or model or color or pelak or shasi or motor or code or vin or bime_end_time or
                takhfif_bime or kilometer or moayene_end_time or fuel or color_details or description or saheb_pelak):
            self.save()


class CarCost(TimeStampedModel):
    car = models.ForeignKey(Car, on_delete=models.CASCADE)
    subject = models.CharField(default="", max_length=256)
    amount = models.BigIntegerField(default=0)
    store = models.CharField(default="", max_length=128)
    description = models.TextField(default="")


class CarType(models.Model):
    name = models.CharField(default="", max_length=64)

    def __unicode__(self):
        return self.name


class CarSystem(models.Model):
    car_type = models.ForeignKey(CarType, on_delete=models.CASCADE)
    name = models.CharField(default="", max_length=64)

    def __unicode__(self):
        return self.name


class CarTip(models.Model):
    car_system = models.ForeignKey(CarSystem, on_delete=models.CASCADE)
    name = models.CharField(default="", max_length=64)

    def __unicode__(self):
        return self.name


class Color(models.Model):
    name = models.CharField(default="", max_length=64)

    def __unicode__(self):
        return self.name
