from rest_framework import serializers

from applications.baygani.models import KharidForo0shCar, MadarekTahvili, SanadMotefarreghe, ShomareBaygani, \
    SanadMotefarregheCar
from applications.cars.serializers import CarInBayganiSerializer, CarInShowBayganiSerializer
from applications.users.serializers import SearchUserSerializer
from applications.utilities.common import get_timestamp


class MadarekTahviliSerializer(serializers.ModelSerializer):
    avArez_ta = serializers.SerializerMethodField()

    class Meta:
        model = MadarekTahvili
        fields = '__all__'

    def get_avArez_ta(self, madarek):
        try:
            return get_timestamp(madarek.avArez_ta)
        except AttributeError:
            return None


class BayganiListSerializer(serializers.ModelSerializer):
    foro0shande = serializers.SerializerMethodField()
    kharid_namayeshgah_datetime = serializers.SerializerMethodField()
    kharidar = serializers.SerializerMethodField()
    gholname_datetime = serializers.SerializerMethodField()
    vekalat_kari_engheza = serializers.SerializerMethodField()
    sanad_dar_rahn_engheza = serializers.SerializerMethodField()
    vekalat_foro0sh_engheza = serializers.SerializerMethodField()
    tahvil_dahande = serializers.SerializerMethodField()
    car = serializers.SerializerMethodField()
    saheb_pelak_ghadim = serializers.SerializerMethodField()
    shomare_baygani = serializers.SerializerMethodField()

    madarek_tahvili = MadarekTahviliSerializer()

    class Meta:
        model = KharidForo0shCar
        # TODO: Vakil, dar rahn, sAheb pelAk ghadim bAs ezAfe she
        fields = ["id", "foro0shande", "kharid_namayeshgah_datetime", "kharidar", "gholname_datetime", "current_state",
                  "vekalat_kari_engheza", "sanad_dar_rahn_engheza", "sanad_dar_rahn_vekalat_kari",
                  "vekalat_foro0sh_engheza", "taviz_pelak_shode_state", "madarek_tahvili", "tahvil_dahande",
                  "description", "pelak_ghadim", "pelak_jadid", "car", "saheb_pelak_ghadim", "shomare_baygani"]

    def get_foro0shande(self, kharid_foro0sh):
        try:
            return kharid_foro0sh.get_foro0shande().get_full_name()
        except AttributeError:
            return None

    def get_car(self, kharid_foro0sh):
        try:
            return CarInBayganiSerializer(kharid_foro0sh.get_car()).data
        except AttributeError:
            return None

    def get_kharid_namayeshgah_datetime(self, kharid_foro0sh):
        try:
            return kharid_foro0sh.get_kharid_date_timestamp()
        except AttributeError:
            return None

    def get_kharidar(self, kharid_foro0sh):
        try:
            return kharid_foro0sh.get_kharidar().get_full_name()
        except AttributeError:
            return None

    def get_gholname_datetime(self, kharid_foro0sh):
        try:
            return kharid_foro0sh.get_gholname_datetime_timestamp()
        except AttributeError:
            return None

    def get_vekalat_kari_engheza(self, kharid_foro0sh):
        try:
            return get_timestamp(kharid_foro0sh.vekalat_kari_engheza)
        except AttributeError:
            return None

    def get_sanad_dar_rahn_engheza(self, kharid_foro0sh):
        try:
            return get_timestamp(kharid_foro0sh.sanad_dar_rahn_engheza)
        except AttributeError:
            return None

    def get_vekalat_foro0sh_engheza(self, kharid_foro0sh):
        try:
            return get_timestamp(kharid_foro0sh.vekalat_foro0sh_engheza)
        except AttributeError:
            return None

    def get_tahvil_dahande(self, kharid_foro0sh):
        try:
            return kharid_foro0sh.tahvil_dahande.get_full_name()
        except AttributeError:
            return None

    def get_saheb_pelak_ghadim(self, kharid_foro0sh):
        try:
            return kharid_foro0sh.gholname_kharid.foro0shande.get_full_name()
        except AttributeError:
            return None

    def get_shomare_baygani(self, kharid_foro0sh):
        if kharid_foro0sh.is_baygani:
            try:
                return kharid_foro0sh.shomare_baygani.number
            except AttributeError:
                numbers = ShomareBaygani.objects.filter(remained__gt=0).order_by("created_at")
                if numbers:
                    shomare_baygani = numbers.first()
                    shomare_baygani.remained -= 1
                    shomare_baygani.save()
                else:
                    numbers = ShomareBaygani.objects.filter(remained=0).order_by("created_at")
                    if numbers:
                        shomare_baygani = numbers.last()
                        number = shomare_baygani.number + 1
                        shomare_baygani = ShomareBaygani.objects.create(number=number, remained=1)
                    else:
                        shomare_baygani = ShomareBaygani.objects.create(number=1, remained=1)
                kharid_foro0sh.shomare_baygani = shomare_baygani
                kharid_foro0sh.save()
                return kharid_foro0sh.shomare_baygani.number
        else:
            return 0


class ShowBayganiSerializer(serializers.ModelSerializer):
    foro0shande = serializers.SerializerMethodField()
    kharid_namayeshgah_datetime = serializers.SerializerMethodField()
    kharidar = serializers.SerializerMethodField()
    gholname_datetime = serializers.SerializerMethodField()
    car = serializers.SerializerMethodField()
    saheb_pelak_ghadim = serializers.SerializerMethodField()
    vakil = SearchUserSerializer()
    tahvil_dahande = SearchUserSerializer()
    pelak_ghadim = serializers.SerializerMethodField()
    vekalat_foro0sh_engheza = serializers.SerializerMethodField()
    vekalat_kari_engheza = serializers.SerializerMethodField()
    shomare_baygani = serializers.SerializerMethodField()
    sanad_dar_rahn_engheza = serializers.SerializerMethodField()
    enter_datetime = serializers.SerializerMethodField()

    madarek_tahvili = MadarekTahviliSerializer()

    class Meta:
        model = KharidForo0shCar
        fields = ["id", "foro0shande", "kharid_namayeshgah_datetime", "kharidar", "gholname_datetime", "current_state",
                  "madarek_tahvili", "pelak_ghadim", "pelak_jadid", "car", "saheb_pelak_ghadim", "dar_hal_hazer",
                  "vakil", "description", "vekalat_kari_engheza", "vekalat_foro0sh_engheza", "tahvil_dahande",
                  "shomare_baygani", "sanad_dar_rahn_engheza", "enter_datetime"]

    def get_vekalat_kari_engheza(self, madarek):
        try:
            return get_timestamp(madarek.avArez_ta)
        except AttributeError:
            return None

    def get_enter_datetime(self, madarek):
        try:
            return get_timestamp(madarek.enter_datetime)
        except AttributeError:
            return None

    def get_vekalat_foro0sh_engheza(self, madarek):
        try:
            return get_timestamp(madarek.avArez_ta)
        except AttributeError:
            return None

    def get_pelak_ghadim(self, kharid_foro0sh):
        try:
            return kharid_foro0sh.gholname_kharid.car.pelak
        except AttributeError:
            return None

    def get_foro0shande(self, kharid_foro0sh):
        try:
            return kharid_foro0sh.get_foro0shande().get_full_name()
        except AttributeError:
            return None

    def get_car(self, kharid_foro0sh):
        try:
            return CarInShowBayganiSerializer(kharid_foro0sh.get_car()).data
        except AttributeError:
            return None

    def get_kharid_namayeshgah_datetime(self, kharid_foro0sh):
        try:
            return kharid_foro0sh.get_kharid_date_timestamp()
        except AttributeError:
            return None

    def get_kharidar(self, kharid_foro0sh):
        try:
            return kharid_foro0sh.get_kharidar().get_full_name()
        except AttributeError:
            return None

    def get_gholname_datetime(self, kharid_foro0sh):
        try:
            return kharid_foro0sh.get_gholname_datetime_timestamp()
        except AttributeError:
            return None

    def get_vekalat_kari_engheza(self, kharid_foro0sh):
        try:
            return get_timestamp(kharid_foro0sh.vekalat_kari_engheza)
        except AttributeError:
            return None

    def get_sanad_dar_rahn_engheza(self, kharid_foro0sh):
        try:
            return get_timestamp(kharid_foro0sh.sanad_dar_rahn_engheza)
        except AttributeError:
            return None

    def get_vekalat_foro0sh_engheza(self, kharid_foro0sh):
        try:
            return get_timestamp(kharid_foro0sh.vekalat_foro0sh_engheza)
        except AttributeError:
            return None

    def get_saheb_pelak_ghadim(self, kharid_foro0sh):
        try:
            return kharid_foro0sh.gholname_kharid.foro0shande.get_full_name()
        except AttributeError:
            return None

    def get_shomare_baygani(self, kharid_foro0sh):
        try:
            return str(kharid_foro0sh.shomare_baygani)
        except AttributeError:
            return ""

    def get_sanad_dar_rahn_engheza(self, kharid_foro0sh):
        try:
            return get_timestamp(kharid_foro0sh.sanad_dar_rahn_engheza)
        except AttributeError:
            return None


class SanadMotefarregheListSerializer(serializers.ModelSerializer):
    enter_datetime = serializers.SerializerMethodField()
    shomare_baygani = serializers.SerializerMethodField()

    class Meta:
        model = SanadMotefarreghe
        fields = ["id", "shomare_baygani", "subject", "enter_datetime", "description"]

    def get_enter_datetime(self, sanad):
        return get_timestamp(sanad.enter_datetime) if sanad.enter_datetime is not None else None

    def get_shomare_baygani(self, sanad):
        try:
            return sanad.shomare_baygani.number
        except AttributeError:
            return "-"


class SanadMotefarregheCarListSerializer(serializers.ModelSerializer):
    shomare_baygani = serializers.SerializerMethodField()

    class Meta:
        model = SanadMotefarregheCar
        fields = ["id", "shomare_baygani", "subject", "system", "tip", "model"]

    def get_shomare_baygani(self, sanad):
        try:
            return sanad.shomare_baygani.number
        except AttributeError:
            return "-"


class SanadMotefarregheCarSerializer(serializers.ModelSerializer):
    shomare_baygani = serializers.SerializerMethodField()
    madarek_tahvili = MadarekTahviliSerializer()
    enter_datetime = serializers.SerializerMethodField()

    class Meta:
        model = SanadMotefarregheCar
        fields = ["id", "shomare_baygani", "subject", "system", "tip", "model", "color", "pelak_ghadim", "pelak_jadid",
                  "shasi", "description", "enter_datetime", "madarek_tahvili", "is_exited"]

    def get_shomare_baygani(self, sanad):
        try:
            return sanad.shomare_baygani.number
        except AttributeError:
            return "-"

    def get_enter_datetime(self, sanad):
        return get_timestamp(sanad.enter_datetime) if sanad.enter_datetime is not None else None
