# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.db import models
from django.utils import timezone

from applications.gholname.models import Gholname
from applications.users.models import User
from applications.utilities.models import TimeStampedModel


class ShomareBaygani(TimeStampedModel):
    remained = models.SmallIntegerField(default=2)
    number = models.IntegerField(default=0)

    def __str__(self):
        return str(self.number)


class MadarekTahvili(models.Model):
    sanad_sabz = models.BooleanField(default=False)
    sanad_company = models.BooleanField(default=False)
    sanad_ghati = models.BooleanField(default=False)
    taiidie_pelak = models.BooleanField(default=False)
    vekalat_kari = models.BooleanField(default=False)
    vekalat_foro0sh = models.BooleanField(default=False)
    avArez_ta = models.DateTimeField(null=True, blank=True)


class KharidForo0shCar(TimeStampedModel):
    shomare_baygani = models.ForeignKey(ShomareBaygani, null=True, blank=True)
    baygani_number = models.IntegerField(default=0)

    gholname_kharid = models.OneToOneField(
        to=Gholname,
        null=True,
        blank=True,
        related_name="kharid",
        on_delete=models.CASCADE
    )

    gholname_foro0sh = models.OneToOneField(
        to=Gholname,
        null=True,
        blank=True,
        related_name="foro0sh",
        on_delete=models.CASCADE
    )

    enter_datetime = models.DateTimeField(null=True, blank=True)
    current_state = models.IntegerField(default=0)
    dar_hal_hazer = models.IntegerField(default=0)
    vekalat_kari_engheza = models.DateTimeField(null=True, blank=True)
    sanad_dar_rahn_engheza = models.DateTimeField(null=True, blank=True)
    sanad_dar_rahn_vekalat_kari = models.BooleanField(default=False)
    vekalat_foro0sh_engheza = models.DateTimeField(null=True, blank=True)
    taviz_pelak_shode_state = models.IntegerField(default=0)  # 0: bedo0ne vekAlat, 1: bA vekAlat e kAri, 2: bA
    # vekAlat e foro0sh
    madarek_tahvili = models.OneToOneField(MadarekTahvili, on_delete=models.CASCADE, null=True, blank=True)
    tahvil_dahande = models.ForeignKey(to=User, on_delete=models.CASCADE, null=True, blank=True)
    description = models.TextField(default="")
    pelak_ghadim = models.CharField(default="", max_length=8)
    pelak_jadid = models.CharField(default="", max_length=8)
    vakil = models.ForeignKey(User, on_delete=models.PROTECT, null=True, blank=True, related_name="vakil_kharidforo0sh")
    is_exited = models.BooleanField(default=False)
    is_baygani = models.BooleanField(default=False)

    def __str__(self):
        try:
            return str(self.shomare_baygani.number)
        except AttributeError:
            return "0"

    def get_foro0shande(self):
        return self.gholname_kharid.foro0shande

    def get_kharidar(self):
        return self.gholname_foro0sh.kharidar

    def get_car(self):
        return self.gholname_kharid.car

    def get_kharid_date_timestamp(self):
        return self.gholname_kharid.tahvil_datetime.strftime("%s")

    def get_gholname_datetime_timestamp(self):
        return self.gholname_foro0sh.datetime.strftime("%s")

    def update(self, current_state=None, vekalat_kari_engheza=None, sanad_dar_rahn_engheza=None,
               vekalat_foro0sh_engheza=None, sanad_sabz=None, sanad_company=None, sanad_ghati=None, taiidie_pelak=None,
               vekalat_kari=None, vekalat_foro0sh=None, avArez_ta=None, enter_datetime=None, tahvil_dahande=None,
               description=None, is_baygani=None, vakil=None, shomare_baygani=None):
        if shomare_baygani is not None:
            self.shomare_baygani = shomare_baygani

        if self.madarek_tahvili is None:
            madarek_tahvili = MadarekTahvili()
        else:
            madarek_tahvili = self.madarek_tahvili

        if current_state is not None:
            self.current_state = current_state
        if vekalat_kari_engheza is not None:
            self.vekalat_kari_engheza = vekalat_kari_engheza
        if sanad_dar_rahn_engheza is not None:
            self.sanad_dar_rahn_engheza = sanad_dar_rahn_engheza
        if vekalat_foro0sh_engheza is not None:
            self.vekalat_foro0sh_engheza = vekalat_foro0sh_engheza
        if sanad_sabz is not None:
            madarek_tahvili.sanad_sabz = sanad_sabz
        if sanad_company is not None:
            madarek_tahvili.sanad_company = sanad_company
        if sanad_ghati is not None:
            madarek_tahvili.sanad_ghati = sanad_ghati
        if taiidie_pelak is not None:
            madarek_tahvili.taiidie_pelak = taiidie_pelak
        if vekalat_kari is not None:
            madarek_tahvili.vekalat_kari = vekalat_kari
        if vekalat_foro0sh is not None:
            madarek_tahvili.vekalat_foro0sh = vekalat_foro0sh
        if avArez_ta is not None:
            madarek_tahvili.avArez_ta = avArez_ta
        if enter_datetime is not None:
            self.enter_datetime = enter_datetime
        if tahvil_dahande is not None:
            self.tahvil_dahande = tahvil_dahande
        if description is not None:
            self.description = description
        if is_baygani is not None:
            self.is_baygani = is_baygani
        if vakil is not None:
            self.vakil = vakil

        if (current_state is not None or vekalat_kari_engheza is not None or sanad_dar_rahn_engheza is not None or
                vekalat_foro0sh_engheza is not None or sanad_sabz is not None or sanad_company is not None or
                sanad_ghati is not None or taiidie_pelak is not None or vekalat_kari is not None or
                vekalat_foro0sh is not None or avArez_ta is not None or enter_datetime is not None or
                tahvil_dahande is not None or description is not None or is_baygani is not None or vakil is not None or
                shomare_baygani is not None):
            madarek_tahvili.save()
            self.madarek_tahvili = madarek_tahvili
            self.save()


class Exit(TimeStampedModel):
    kharid_foro0sh = models.ForeignKey(KharidForo0shCar, on_delete=models.CASCADE)
    datetime = models.DateTimeField(default=timezone.now)
    tahvil_girande = models.ForeignKey(to=User, on_delete=models.CASCADE)
    ellat = models.IntegerField(default=0)
    madarek_tahvili = models.OneToOneField(MadarekTahvili, on_delete=models.CASCADE, null=True, blank=True)
    bargasht_datetime_ehtemali = models.DateTimeField(null=True, blank=True)
    need_to_reminder = models.IntegerField(default=0)
    vaziat_bedehi_kharidar = models.BigIntegerField(default=0)
    description = models.TextField(default="", null=True, blank=True)


class Enter(TimeStampedModel):
    kharid_foro0sh = models.ForeignKey(KharidForo0shCar, on_delete=models.CASCADE)
    tahvil_dahande = models.ForeignKey(to=User, on_delete=models.CASCADE)
    madarek_tahvili = models.OneToOneField(MadarekTahvili, on_delete=models.CASCADE, null=True, blank=True)
    is_fak_rahn = models.BooleanField(default=False)
    datetime = models.DateTimeField(default=timezone.now)
    is_finished = models.BooleanField(default=False)


class SanadMotefarreghe(TimeStampedModel):
    shomare_baygani = models.ForeignKey(ShomareBaygani, null=True, blank=True)
    enter_datetime = models.DateTimeField(null=True, blank=True)
    subject = models.CharField(default="", max_length=200)
    description = models.TextField(default="")
    is_exited = models.BooleanField(default=False)

    def __str__(self):
        return str(self.shomare_baygani)


class SanadMotefarregheCar(TimeStampedModel):
    shomare_baygani = models.ForeignKey(ShomareBaygani, null=True, blank=True)
    subject = models.CharField(default="", max_length=64)
    system = models.CharField(default="", max_length=64)
    tip = models.CharField(default="", max_length=64)
    model = models.CharField(default="", max_length=64)
    color = models.CharField(default="", max_length=64)
    pelak_ghadim = models.CharField(null=True, default="", max_length=8)
    pelak_jadid = models.CharField(null=True, default="", max_length=8)
    shasi = models.CharField(default="", max_length=64)
    description = models.TextField(null=True, default="")
    enter_datetime = models.DateTimeField(null=True, blank=True)
    madarek_tahvili = models.OneToOneField(MadarekTahvili, on_delete=models.CASCADE, null=True, blank=True)
    is_exited = models.BooleanField(default=False)

    def update(self, subject=None, system=None, tip=None, model=None, color=None, pelak_ghadim=None, pelak_jadid=None,
               shasi=None, sanad_sabz=None, sanad_company=None, sanad_ghati=None, taiidie_pelak=None,
               vekalat_kari=None, vekalat_foro0sh=None, avArez_ta=None, enter_datetime=None,
               description=None):
        if subject is not None:
            self.subject = subject
        if system is not None:
            self.system = system
        if tip is not None:
            self.tip = tip
        if model is not None:
            self.model = model
        if color is not None:
            self.color = color
        if pelak_ghadim is not None:
            self.pelak_ghadim = pelak_ghadim
        if pelak_jadid is not None:
            self.pelak_jadid = pelak_jadid
        if shasi is not None:
            self.shasi = shasi

        if self.madarek_tahvili is None:
            madarek_tahvili = MadarekTahvili()
        else:
            madarek_tahvili = self.madarek_tahvili

        if sanad_sabz is not None:
            madarek_tahvili.sanad_sabz = sanad_sabz
        if sanad_company is not None:
            madarek_tahvili.sanad_company = sanad_company
        if sanad_ghati is not None:
            madarek_tahvili.sanad_ghati = sanad_ghati
        if taiidie_pelak is not None:
            madarek_tahvili.taiidie_pelak = taiidie_pelak
        if vekalat_kari is not None:
            madarek_tahvili.vekalat_kari = vekalat_kari
        if vekalat_foro0sh is not None:
            madarek_tahvili.vekalat_foro0sh = vekalat_foro0sh
        if avArez_ta is not None:
            madarek_tahvili.avArez_ta = avArez_ta
        if enter_datetime is not None:
            self.enter_datetime = enter_datetime
        if description is not None:
            self.description = description

        if (subject is not None or system is not None or tip is not None or model is not None or color is not None or
                pelak_ghadim is not None or pelak_jadid is not None or shasi is not None or sanad_sabz is not None or
                sanad_company is not None or sanad_ghati is not None or taiidie_pelak is not None or
                vekalat_kari is not None or vekalat_foro0sh is not None or avArez_ta is not None or
                enter_datetime is not None or description is not None):
            madarek_tahvili.save()
            self.madarek_tahvili = madarek_tahvili
            self.save()
