from django.conf.urls import url

from applications.accounting.views import (
    DaryaftAzTarafHesabView, BanksView, DafaterKolView, PardakhtBeTarafHesabView,
    CheksView,
    TalabkarView,
    BedehkarView,
    HesabDafaterKolView,
    SandoghView,
    HesabDafaterKolsView,
    TransfersView,
    DafaterKolDetailView, HesabDafateriView, ChekView, HesabDafateriGhestView, HesabKolView
)

app_name = 'accounting'

urlpatterns = [
    url(r'^daryaft_az_taraf_hesab/$', DaryaftAzTarafHesabView.as_view()),
    url(r'^pardakht_be_taraf_hesab/$', PardakhtBeTarafHesabView.as_view()),
    url(r'^cheks/$', CheksView.as_view()),
    url(r'^chek/(?P<chek_id>[0-9]+)/$', ChekView.as_view()),
    url(r'^banks/$', BanksView.as_view()),
    url(r'^dafater_kol/$', DafaterKolView.as_view()),
    url(r'^hesab_kol/$', HesabKolView.as_view()),
    url(r'^dafater_kol/(?P<daftar_id>[0-9]+)/$', DafaterKolDetailView.as_view()),
    url(r'^hesba_daftar_kols/$', HesabDafaterKolsView.as_view()),
    url(r'^hesba_daftar_kol/$', HesabDafaterKolView.as_view()),
    url(r'^hesba_daftari/$', HesabDafateriView.as_view()),
    url(r'^daily/$', HesabDafateriGhestView.as_view()),
    url(r'^talabkar/$', TalabkarView.as_view()),
    url(r'^bedehkar/$', BedehkarView.as_view()),
    url(r'^sandogh/$', SandoghView.as_view()),
    url(r'^transfers/$', TransfersView.as_view()),
]
