# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.db import models

from applications.users.models import User
from applications.utilities.models import TimeStampedModel


class DaftarKol(models.Model):
    name = models.CharField(max_length=128)

    def __unicode__(self):
        return self.name


#
class Bank(models.Model):
    name = models.CharField(max_length=70)

    def __unicode__(self):
        return self.name


#
class HesabDaftarKol(models.Model):
    name = models.CharField(max_length=128)
    daftar_kol = models.ForeignKey(DaftarKol, on_delete=models.SET_NULL, null=True)
    bank = models.ForeignKey(Bank, on_delete=models.CASCADE)
    shobe = models.CharField(max_length=128, default='')
    code_shobe = models.CharField(max_length=128, default='')
    shomare_hesab = models.CharField(max_length=128, default='')
    saheb_hesab = models.CharField(max_length=128, default='')
    telephone = models.CharField(max_length=128, default='')
    tozihat = models.TextField(default='')
    has_chek = models.BooleanField(default=False)
    has_pos = models.BooleanField(default=False)
    has_card = models.BooleanField(default=False)


class Chek(models.Model):
    CHEK_STATUS_DELETE = 0
    CHEK_STATUS_VOSUL = 1
    CHEK_STATUS_RETURN = 2
    CHEK_STATUS_PASS = 3
    CHEK_STATUS_DELAY = 4

    tarikh_sarresid = models.DateField()
    tarikh_pardakht = models.DateField(null=True)
    bank = models.ForeignKey(Bank, on_delete=models.CASCADE)
    shomare_chek = models.CharField(max_length=30)
    dar_vajh = models.CharField(null=True, blank=True, max_length=128)
    code = models.CharField(max_length=20, null=True, blank=True)
    shobe = models.CharField(max_length=64, null=True, blank=True)
    shomare_hesab = models.CharField(max_length=64, null=True, blank=True)
    saheb_hesab = models.CharField(max_length=64)
    mablagh = models.PositiveIntegerField()
    daryafti = models.ForeignKey('DaryaftAzTarafHesab', on_delete=models.CASCADE, null=True)
    pardakhti = models.ForeignKey('PardakhtBeTarafHesab', on_delete=models.CASCADE, null=True)
    is_self = models.BooleanField()
    status = models.SmallIntegerField(null=True)

    def __unicode__(self):
        return self.shomare_chek


#
class ChekStatus(TimeStampedModel):
    chek = models.OneToOneField(Chek, on_delete=models.CASCADE)
    tozihat = models.TextField(default='')

    class Meta:
        abstract = True


class ChekStatusDelete(ChekStatus):
    pass


class ChekStatusVosul(ChekStatus):
    hesab = models.ForeignKey(HesabDaftarKol, on_delete=models.CASCADE)
    date = models.DateField()
    kar_mozd = models.BigIntegerField(default=0)


class ChekStatusReturn(ChekStatus):
    bank = models.ForeignKey(Bank, on_delete=models.CASCADE, null=True)
    date = models.DateField()
    kar_mozd = models.BigIntegerField(default=0)


class ChekStatusPass(ChekStatus):
    date = models.DateField()


class ChekStatusDelay(ChekStatus):
    date = models.DateField()
    elat = models.TextField(default='')


#
class DaryaftAzTarafHesab(TimeStampedModel):
    KHARID_KHODRO = "KHARID_KHODRO"
    HESAB_DAFTARI = "HESAB_DAFTARI"
    DAFTAR_KOL = "DAFTAR_KOL"
    ESLAHIE_HESAB_DAFTARI = "ESLAHIE_HESAB_DAFTARI"
    ESLAHIE_DAFTAR_KOL = "ESLAHIE_DAFTAR_KOL"
    FAGHAT_HESAB_DAFTARI = "FAGHAT_HESAB_DAFTARI"

    JAHAT = [
        (KHARID_KHODRO, 'خرید خودرو'),
        (HESAB_DAFTARI, 'حساب دفتری'),
        (DAFTAR_KOL, 'دفتر کل'),
        (ESLAHIE_HESAB_DAFTARI, 'اصلاحیه حساب دفتری'),
        (ESLAHIE_DAFTAR_KOL, 'اصلاحیه دفتر کل'),
        (FAGHAT_HESAB_DAFTARI, 'فقط حساب دفتری'),
    ]

    DAFTAR_JAHATS = [
        KHARID_KHODRO,
        HESAB_DAFTARI,
        DAFTAR_KOL,
        ESLAHIE_DAFTAR_KOL,
    ]

    HESAB_JAHATS = [
        HESAB_DAFTARI,
        ESLAHIE_HESAB_DAFTARI,
        FAGHAT_HESAB_DAFTARI
    ]

    JAHATS = [i[0] for i in JAHAT]

    pardakht_konande = models.ForeignKey(User, related_name="pardakht_konande_taraf_hesabs")
    tavassot = models.ForeignKey(User, related_name="tavasot_pardakht_taraf_hesabs")
    tarikh_daryaft = models.DateField()
    jahat = models.CharField(max_length=100, choices=JAHAT)
    hesab_daftar_kol = models.ForeignKey(HesabDaftarKol, on_delete=models.CASCADE)
    bAbat = models.CharField(max_length=256, null=True, blank=True)
    tozihat = models.TextField(default="", null=True, blank=True)
    pos_amount = models.PositiveIntegerField(default=0)
    card_amount = models.PositiveIntegerField(default=0)
    cash = models.PositiveIntegerField(default=0)
    talab_bedeh_ghest = models.ForeignKey('TalabBedehGhest', null=True, on_delete=models.CASCADE)


#
class PardakhtBeTarafHesab(TimeStampedModel):
    FORUSH_KHODRO = "KHARID_KHODRO"
    HESAB_DAFTARI = "HESAB_DAFTARI"
    DAFTAR_KOL = "DAFTAR_KOL"
    ESLAHIE_HESAB_DAFTARI = "ESLAHIE_HESAB_DAFTARI"
    ESLAHIE_DAFTAR_KOL = "ESLAHIE_DAFTAR_KOL"
    FAGHAT_HESAB_DAFTARI = "FAGHAT_HESAB_DAFTARI"

    JAHAT = [
        (FORUSH_KHODRO, 'فروش خودرو'),
        (HESAB_DAFTARI, 'حساب دفتری'),
        (DAFTAR_KOL, 'دفتر کل'),
        (ESLAHIE_HESAB_DAFTARI, 'اصلاحیه حساب دفتری'),
        (ESLAHIE_DAFTAR_KOL, 'اصلاحیه دفتر کل'),
        (FAGHAT_HESAB_DAFTARI, 'فقط حساب دفتری'),
    ]
    JAHATS = [i[0] for i in JAHAT]

    DAFTAR_JAHATS = [
        FORUSH_KHODRO,
        HESAB_DAFTARI,
        DAFTAR_KOL,
        ESLAHIE_DAFTAR_KOL,
    ]

    HESAB_JAHATS = [
        HESAB_DAFTARI,
        ESLAHIE_HESAB_DAFTARI,
        FAGHAT_HESAB_DAFTARI
    ]

    daryaft_konande = models.ForeignKey(User, related_name="daryaft_konande_taraf_hesabs")
    tavassot = models.ForeignKey(User, related_name="tavasot_daryaft_taraf_hesabs")
    tarikh_pardakht = models.DateField()
    jahat = models.CharField(max_length=100, choices=JAHAT)
    hesab_daftar_kol = models.ForeignKey(HesabDaftarKol, on_delete=models.CASCADE)
    bAbat = models.CharField(max_length=256, null=True, blank=True)
    tozihat = models.TextField(default="", null=True, blank=True)
    pos_amount = models.PositiveIntegerField(default=0)
    card_amount = models.PositiveIntegerField(default=0)
    cash = models.PositiveIntegerField(default=0)
    carmozd = models.PositiveIntegerField(default=0)
    talab_bedeh_ghest = models.ForeignKey('TalabBedehGhest', null=True, on_delete=models.CASCADE)


class TalabBedeh(TimeStampedModel):
    shakhs = models.ForeignKey(User, on_delete=models.CASCADE)
    babat = models.CharField(max_length=1024)
    amount = models.IntegerField()
    tarikh_sabt = models.DateField()
    tozihat = models.TextField()
    is_talab = models.BooleanField()
    num_type = models.NullBooleanField()
    qnum = models.IntegerField(null=True)
    tarikh_daryaft = models.DateField(null=True)
    deleted = models.BooleanField(default=False)


class TalabBedehGhest(TimeStampedModel):
    talab_bedeh = models.ForeignKey(TalabBedeh, on_delete=models.CASCADE)
    num = models.IntegerField()
    amount = models.IntegerField()
    tarikh_daryaft = models.DateField()
    tarikh_amal = models.DateField(null=True, default=None)
    deleted = models.BooleanField(default=False)
    tozihat = models.TextField(default='')


class BankTransfer(TimeStampedModel):
    TARIGH_POS = 0
    TARIGH_NAGHDI = 1
    TARIGH_CARD = 2
    TARIGH_CHEK_BANK = 3
    TARIGH_HAVALE = 4
    TARIGH_CHEK = 5

    TARIGHS = {
        TARIGH_POS: 'پوز',
        TARIGH_NAGHDI: 'نقدی',
        TARIGH_CARD: 'کارت به کارت',
        TARIGH_CHEK_BANK: 'چک بانکی',
        TARIGH_HAVALE: 'حواله',
        TARIGH_CHEK: 'چک',
    }
    tarigh = models.SmallIntegerField()
    mabda = models.ForeignKey(HesabDaftarKol, on_delete=models.CASCADE, null=True, related_name='bt_mabda_hesab')
    maghsad = models.ForeignKey(HesabDaftarKol, on_delete=models.CASCADE, null=True, related_name='bt_maghsad_hesab')
    sabt = models.DateTimeField()
    amal = models.DateTimeField()
    mablagh = models.BigIntegerField()
    karmozd = models.BigIntegerField()
    description = models.TextField()
    babat = models.TextField()
    tavasot = models.ForeignKey(User, on_delete=models.CASCADE)
