# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.contrib import admin

from applications.accounting.models import (
    DaftarKol, Bank, Chek, DaryaftAzTarafHesab,
    HesabDaftarKol
)


@admin.register(DaftarKol)
class DaftarKolAdmin(admin.ModelAdmin):
    list_display = ["name"]


@admin.register(Bank)
class BankAdmin(admin.ModelAdmin):
    list_display = ["name"]


@admin.register(Chek)
class ChekAdmin(admin.ModelAdmin):
    list_display = ["tarikh_sarresid", "bank", "shomare_chek", "dar_vajh", "code", "shobe", "shomare_hesab",
                    "saheb_hesab", "mablagh"]


@admin.register(DaryaftAzTarafHesab)
class DaryaftAzTarafHesabAdmin(admin.ModelAdmin):
    list_display = ["pardakht_konande", "tavassot", "tarikh_daryaft", "jahat", "hesab_daftar_kol", "bAbat", "tozihat",
                    "pos_amount", "card_amount", "cash"]


@admin.register(HesabDaftarKol)
class HesabDaftarKolAdmin(admin.ModelAdmin):
    list_display = ["name", "bank", "daftar_kol"]
