import {Injectable} from '@angular/core';
import {environment} from '../../environments/environment';
import {Headers, Http} from '@angular/http';
import {NgxPersianNumbersService} from '../../../node_modules/ngx-persian-number/src/services/ngx-persian-numbers.service';
import {
  ChekDataInterface,
  DaftarKol,
  DaryaftAzTarafHesabParams,
  gholnameSearchParams,
  HesabDaftarKol,
  PardakhtBeTarafHesabParams,
  TalBed
} from '../interfaces';

const loggedInHeaders = new Headers({
  'Authorization': 'Token ' + localStorage.getItem('token'),
  'Content-Type': 'application/json'
});


@Injectable()
export class ConnectorService {
  public serverAddress = environment.serverAddress;

  /***
   *
   * @param {Http} http
   * @param {NgxPersianNumbersService} ngxNum
   */
  constructor(public http: Http, public ngxNum: NgxPersianNumbersService) {

  }

  /***
   ************************ Gholname ************************
   */

  /***
   *
   * @returns {Observable<Response>}
   */
  cancelGholname(id) {
    return this.http.delete(this.serverAddress + '/gholname/cancel/' + id + '/', {headers: loggedInHeaders});
  }

  getKharidVaForoshList(page, name?: any) {
    return this.http.get(this.serverAddress + '/baygani/kharid_foro0sh/list/',
      {params: {page: page, name: name}, headers: loggedInHeaders});
  }

  /***
   *
   * @param searchParams
   * @returns {Observable<Response>}
   */
  getGholnameList2(searchParams: gholnameSearchParams) {
    return this.http.get(this.serverAddress + '/gholname/list2/',
      {
        headers: loggedInHeaders,
        params: {
          page: searchParams.page,
          name: searchParams.name,
          code_melli: searchParams.code_melli,
          system: searchParams.system,
          pelak_ghadim: searchParams.pelak_ghadim,
          pelak_jadid: searchParams.pelak_jadid,
          motor: searchParams.motor,
          shasi: searchParams.shasi,
          type_kharid_namayeshgah: searchParams.types_kharid_namayeshgah ? 1 : 0,
          type_naghdi: searchParams.types_naghdi ? 1 : 0,
          type_aghsati: searchParams.types_aghsati ? 1 : 0,
          type_sefr_aghsati: searchParams.types_sefr_aghsati ? 1 : 0,
          type_sefr_naghdi: searchParams.types_sefr_naghdi ? 1 : 0,
          type_sefr_lizing: searchParams.types_sefr_lizing ? 1 : 0,
          type_is_faskh: searchParams.types_is_faskh ? 1 : 0,
        }
      });
  }

  /***
   *
   * @param gholname
   * @returns {Observable<Response>}
   */
  createGholnameSerfNaghdi(gholname) {
    gholname.pelak = gholname.pelak !== '۱۱ک۱۱۱' ? gholname.pelak : '';
    return this.http.post(this.serverAddress + '/gholname/sefr/naghdi/', {
        name: gholname.name,
        system: gholname.system,
        tip: gholname.tip,
        model: gholname.model,
        color: gholname.color,
        pelak: gholname.pelak,
        shasi: gholname.shasi,
        motor: gholname.motor,
        gholname_datetime: gholname.gholname_datetime,
        tahvil_datetime: gholname.tahvil_datetime,
        total_cost: this.ngxNum.removeLettersFromString(gholname.total_cost),
        pish_pardakht: this.ngxNum.removeLettersFromString(gholname.pish_pardakht),
        main_cost: this.ngxNum.removeLettersFromString(gholname.main_cost),
        kharj_sanad: gholname.kharj_sanad,
        dong: gholname.dong,
        saheb_pelak_id: gholname.saheb_pelak_id,
        kharidar_id: gholname.kharidar_id,
        manba_kharid_id: gholname.manba_kharid_id,
        foro0shande_id: gholname.foro0shande_id,
        description: gholname.description,
        shomare_dasti: gholname.shomare_dasti,
        code: gholname.code,
        VIN: gholname.vin
      },
      {headers: loggedInHeaders});
  }

  /***
   *
   * @param gholnameId
   * @returns {Observable<Response>}
   */
  getGholnameNaghdi(gholnameId) {
    return this.http.get(this.serverAddress + '/gholname/naghdi/' + gholnameId + '/',
      {headers: loggedInHeaders});
  }

  /***
   *
   * @param gholname
   */
  editGholnameSefrNaghdi(gholname) {
    gholname.car.pelak = gholname.pelak !== '۱۱ک۱۱۱' ? gholname.car.pelak : ' ';
    return this.http.put(this.serverAddress + '/gholname/sefr/naghdi/' + gholname.gholname.id + '/', {
      code: gholname.car.code,
      VIN: gholname.car.vin,
      name: gholname.car.name,
      system: gholname.car.system,
      tip: gholname.car.tip,
      model: gholname.car.model,
      color: gholname.car.color,
      pelak: gholname.car.pelak,
      shasi: gholname.car.shasi,
      motor: gholname.car.motor,
      gholname_datetime: gholname.gholname.datetime,
      tahvil_datetime: gholname.gholname.tahvil_datetime,
      total_cost: this.ngxNum.removeLettersFromString(gholname.gholname.total_cost),
      pish_pardakht: this.ngxNum.removeLettersFromString(gholname.gholname.pish_pardakht),
      kharj_sanad: gholname.gholname.kharj_sanad,
      saheb_pelak_id: gholname.gholname.saheb_pelak_id,
      dong: gholname.gholname.dong,
      kharidar_id: gholname.gholname.kharidar.id,
      manba_kharid_id: gholname.manba_kharid.id,
      foro0shande_id: gholname.gholname.foro0shande.id,
      description: gholname.gholname.description,
      shomare_dasti: gholname.gholname.shomare_dasti

    }, {headers: loggedInHeaders});
  }

  editGholnameLizing(gholname) {
    console.log(gholname);
    return this.http.put(this.serverAddress + '/gholname/sefr/lizing/' + gholname.gholname.id + '/',
      {
        code: gholname.car.code,
        VIN: gholname.car.vin,
        name: gholname.car.name,
        system: gholname.car.system,
        tip: gholname.car.tip,
        model: gholname.car.model,
        color: gholname.car.color,
        pelak: gholname.car.pelak,
        shasi: gholname.car.shasi,
        motor: gholname.car.motor,
        total_cost: this.ngxNum.removeLettersFromString(gholname.gholname.total_cost),
        gholname_datetime: gholname.gholname.datetime,
        tahvil_datetime: gholname.gholname.tahvil_datetime,
        pish_pardakht: this.ngxNum.removeLettersFromString(gholname.gholname.pish_pardakht),
        kharj_sanad: gholname.gholname.kharj_sanad,
        dong: gholname.gholname.dong,
        kharidar_id: gholname.gholname.kharidar.id,
        foro0shande_id: gholname.gholname.foro0shande.id,
        manba_kharid_id: gholname.manba_kharid.id,
        description: gholname.gholname.description,
        moddat_chek: gholname.moddat_chek,
        shomare_dasti: gholname.gholname.shomare_dasti
      },
      {headers: loggedInHeaders});
  }

  /***
   *
   * @param gholname
   * @returns {Observable<Response>}
   */
  editGholnameNaghdi(gholname) {
    return this.http.put(this.serverAddress + '/gholname/naghdi/' + gholname.gholname.id + '/',
      {
        car_id: gholname.car.id,
        total_cost: this.ngxNum.removeLettersFromString(gholname.gholname.total_cost),
        gholname_datetime: gholname.gholname.datetime,
        tahvil_datetime: gholname.gholname.tahvil_datetime,
        pish_pardakht: this.ngxNum.removeLettersFromString(gholname.gholname.pish_pardakht),
        kharj_sanad: gholname.gholname.kharj_sanad,
        dong: gholname.gholname.dong,
        kharidar_id: gholname.gholname.kharidar.id,
        foro0shande_id: gholname.gholname.foro0shande.id,
        description: gholname.gholname.description
      },
      {headers: loggedInHeaders});
  }

  /***
   *
   * @param gholnameId
   * @returns {Observable<Response>}
   */
  getGholnameAghsati(gholnameId) {
    return this.http.get(this.serverAddress + '/gholname/aghsati/' + gholnameId + '/'
      , {headers: loggedInHeaders});
  }

  editGholnameKharidNamayeshgah(gholname) {
    return this.http.put(this.serverAddress + '/gholname/kharid_namayeshgah/' + gholname.gholname.id + '/', {
      name: gholname.car.name,
      system: gholname.car.system,
      tip: gholname.car.tip,
      model: gholname.car.model,
      color: gholname.car.color,
      pelak: gholname.car.pelak,
      shasi: gholname.car.shasi,
      motor: gholname.car.motor,
      code: gholname.car.code,
      VIN: gholname.car.vin,
      gholname_datetime: gholname.gholname.datetime,
      tahvil_datetime: gholname.gholname.tahvil_datetime,
      total_cost: this.ngxNum.removeLettersFromString(gholname.gholname.total_cost),
      pish_pardakht: this.ngxNum.removeLettersFromString(gholname.gholname.pish_pardakht),
      kharj_sanad: gholname.gholname.kharj_sanad,
      dong: gholname.gholname.dong,
      saheb_pelak_id: gholname.car.saheb_pelak.id,
      kharidar_id: gholname.gholname.kharidar.id,
      foro0shande_id: gholname.gholname.foro0shande.id,
      description: gholname.gholname.description,
      shomare_dasti: gholname.gholname.shomare_dasti,
    }, {headers: loggedInHeaders});
  }

  /**
   *
   * @param gholname
   * @returns {Observable<Response>}
   */
  editGholnameSefrAghsati(gholname) {
    const body = {
      name: gholname.car.name,
      system: gholname.car.system,
      tip: gholname.car.tip,
      saheb_pelak_id: gholname.saheb_pelak_id,
      model: gholname.car.model,
      color: gholname.car.color,
      pelak: gholname.car.pelak,
      shasi: gholname.car.shasi,
      motor: gholname.car.motor,
      code: gholname.car.code,
      VIN: gholname.car.vin,
      gholname_datetime: gholname.gholname.datetime,
      tahvil_datetime: gholname.gholname.tahvil_datetime,
      total_cost: this.ngxNum.removeLettersFromString(gholname.gholname.total_cost),
      pish_pardakht: this.ngxNum.removeLettersFromString(gholname.gholname.pish_pardakht),
      dong: gholname.dong,
      kharj_sanad: gholname.gholname.kharj_sanad,
      foro0shande_id: gholname.gholname.foro0shande.id,
      kharidar_id: gholname.gholname.kharidar.id,
      description: gholname.gholname.description,
      ghest_num: gholname.num_of_ghest,
      percent_num: gholname.percent,
      ghest_start_datetime: gholname.ghest_start_time,
      shomare_dasti: gholname.gholname.shomare_dasti
    };
    console.log(body);
    return this.http.put(this.serverAddress + '/gholname/sefr/aghsati/' + gholname.gholname.id + '/', body, {headers: loggedInHeaders});
  }

  editGholnameAghsati(gholname) {
    return this.http.put(this.serverAddress + '/gholname/aghsati/' + gholname.gholname.id + '/', {
      car_id: gholname.car.id,
      gholname_datetime: gholname.gholname.datetime,
      tahvil_datetime: gholname.gholname.tahvil_datetime,
      total_cost: this.ngxNum.removeLettersFromString(gholname.gholname.total_cost),
      pish_pardakht: this.ngxNum.removeLettersFromString(gholname.gholname.pish_pardakht),
      dong: gholname.dong,
      kharj_sanad: gholname.gholname.kharj_sanad,
      foro0shande_id: gholname.gholname.foro0shande.id,
      kharidar_id: gholname.gholname.kharidar.id,
      description: gholname.gholname.description,
      ghest_num: gholname.num_of_ghest,
      percent_num: gholname.percent,
      saheb_pelak_id: gholname.saheb_pelak_id,
      ghest_start_datetime: gholname.ghest_start_time
    }, {headers: loggedInHeaders});
  }

  /***
   *
   * @param gholnameId
   */
  getGholnameLizing(gholnameId) {
    return this.http.get(this.serverAddress + '/gholname/sefr/lizing/' + gholnameId + '/', {headers: loggedInHeaders});
  }

  /***
   *
   * @param gholnameId
   * @returns {Observable<Response>}
   */
  getGholnameKharidNamayeshgah(gholnameId) {
    return this.http.get(this.serverAddress + '/gholname/kharid_namayeshgah/' + gholnameId + '/',
      {headers: loggedInHeaders});
  }


  /***
   *
   * @returns {Observable<Response>}
   */
  getShomare_sanad_jadid() {
    return this.http.get(this.serverAddress + '/gholname/shomare_sanad/',
      {headers: loggedInHeaders});
  }

  /***
   *
   * @param id
   * @returns {Observable<Response>}
   */
  getGhests(id, i) {
    return this.http.get(this.serverAddress + '/gholname/ghests/' + id + '/?page=' + i, {headers: loggedInHeaders});
  }

  /***
   *
   * @param gholname
   * @returns {Observable<Response>}
   */

  createGholnameSefrLizing(gholname) {
    gholname.pelak = gholname.pelak !== '۱۱ک۱۱۱' ? gholname.pelak : ' ';
    return this.http.post(this.serverAddress + '/gholname/sefr/lizing/',
      {
        name: gholname.name,
        system: gholname.system,
        tip: gholname.tip,
        model: gholname.model,
        color: gholname.color,
        pelak: gholname.pelak,
        shasi: gholname.shasi,
        motor: gholname.motor,
        gholname_datetime: gholname.gholname_datetime,
        tahvil_datetime: gholname.tahvil_datetime,
        total_cost: this.ngxNum.removeLettersFromString(gholname.total_cost),
        pish_pardakht: this.ngxNum.removeLettersFromString(gholname.pish_pardakht),
        main_cost: this.ngxNum.removeLettersFromString(gholname.main_cost),
        kharj_sanad: gholname.kharj_sanad,
        dong: gholname.dong,
        kharidar_id: gholname.kharidar_id,
        manba_kharid_id: gholname.manba_kharid_id,
        foro0shande_id: gholname.foro0shande_id,
        description: gholname.description,
        chek_num: gholname.chek_num,
        moddat_chek: gholname.moddat_check
      }, {headers: loggedInHeaders});
  }

  /***
   *
   * @param gholname
   * @returns {Observable<Response>}
   */
  createGholnameNaghdi(gholname) {
    return this.http.post(this.serverAddress + '/gholname/naghdi/',
      {
        car_id: gholname.car_id,
        gholname_datetime: gholname.gholname_datetime,
        tahvil_datetime: gholname.tahvil_datetime,
        total_cost: this.ngxNum.removeLettersFromString(gholname.total_cost),
        pish_pardakht: this.ngxNum.removeLettersFromString(gholname.pish_pardakht),
        main_cost: this.ngxNum.removeLettersFromString(gholname.main_cost),
        kharj_sanad: gholname.kharj_sanad,
        dong: gholname.dong,
        kharidar_id: gholname.kharidar_id,
        foro0shande_id: gholname.foro0shande_id,
        description: gholname.description
      }, {headers: loggedInHeaders});
  }

  /***
   *
   * @param gholname
   * @returns {Observable<Response>}
   */
  createGholnmaeAghsati(gholname) {
    return this.http.post(this.serverAddress + '/gholname/aghsati/',
      {
        car_id: gholname.car_id,
        gholname_datetime: gholname.gholname_datetime,
        tahvil_datetime: gholname.tahvil_datetime,
        total_cost: this.ngxNum.removeLettersFromString(gholname.total_cost),
        pish_pardakht: this.ngxNum.removeLettersFromString(gholname.pish_pardakht),
        main_cost: this.ngxNum.removeLettersFromString(gholname.main_cost),
        kharj_sanad: gholname.kharj_sanad,
        dong: gholname.dong,
        kharidar_id: gholname.kharidar_id,
        foro0shande_id: gholname.foro0shande_id,
        description: gholname.description,
        ghest_num: gholname.ghest_num,
        percent_num: gholname.percent_num,
        ghest_start_datetime: gholname.ghest_start_datetime,
        mablagh_e_ghest: gholname.mablagh_e_ghest
      }, {headers: loggedInHeaders});

  }

  /***
   *
   * @param gholname
   * @returns {Observable<Response>}
   */
  createGholnameKharidNamayeshgah(gholname) {
    return this.http.post(this.serverAddress + '/gholname/kharid_namayeshgah/',
      {
        color: gholname.color,
        name: gholname.name,
        system: gholname.system,
        shasi: gholname.shasi,
        pelak: gholname.pelak,
        model: gholname.model,
        tip: gholname.tip,
        gholname_datetime: gholname.gholname_datetime,
        motor: gholname.motor,
        tahvil_datetime: gholname.tahvil_datetime,
        total_cost: this.ngxNum.removeLettersFromString(gholname.total_cost),
        pish_pardakht: this.ngxNum.removeLettersFromString(gholname.pish_pardakht),
        kharj_sanad: gholname.kharj_sanad,
        dong: gholname.dong,
        saheb_pelak_id: gholname.saheb_pelak_id,
        kharidar_id: gholname.kharidar_id,
        shomare_dasti: gholname.shomare_dasti,
        foro0shande_id: gholname.foro0shande_id,
        code: gholname.code,
        VIN: gholname.vin,
        description: gholname.description
      },
      {headers: loggedInHeaders});
  }

  /***
   *
   * @param gholname
   * @returns {Observable<Response>}
   */
  createGholnamesefrAghsati(gholname) {
    gholname.pelak = gholname.pelak !== '۱۱ک۱۱۱' ? gholname.pelak : '';
    return this.http.post(this.serverAddress + '/gholname/sefr/aghsati/', {
      name: gholname.name,
      system: gholname.system,
      tip: gholname.tip,
      model: gholname.model,
      color: gholname.color,
      pelak: gholname.pelak,
      shasi: gholname.shasi,
      motor: gholname.motor,
      gholname_datetime: gholname.gholname_datetime,
      tahvil_datetime: gholname.tahvil_datetime,
      total_cost: this.ngxNum.removeLettersFromString(gholname.total_cost),
      pish_pardakht: this.ngxNum.removeLettersFromString(gholname.pish_pardakht),
      main_cost: this.ngxNum.removeLettersFromString(gholname.main_cost),
      kharj_sanad: gholname.kharj_sanad,
      dong: gholname.dong,
      saheb_pelak_id: gholname.saheb_pelak_id,
      kharidar_id: gholname.kharidar_id,
      manba_kharid_id: gholname.manba_kharid_id,
      foro0shande_id: gholname.foro0shande_id,
      description: gholname.description,
      shomare_dasti: gholname.shomare_dasti,
      code: gholname.code,
      VIN: gholname.vin,
      ghest_num: gholname.ghest_num,
      percent_num: gholname.percent_num,
      ghest_start_datetime: gholname.ghest_start_datetime,
    }, {headers: loggedInHeaders});
  }

  /***
   *
   * @param id
   * @returns {Observable<Response>}
   */
  faskhGholname(faskhData) {
    return this.http.post(this.serverAddress + '/gholname/faskh/' + faskhData.id + '/', {
        faskh_datetime: faskhData.faskh_datetime,
        sabt_datetime: faskhData.sabt_datetime,
        description: faskhData.description
      },
      {headers: loggedInHeaders});
  }

  /***
   *
   * @param id
   * @returns {Observable<Response>}
   */
  getFaskhDetails(id) {
    return this.http.get(this.serverAddress + '/gholname/faskh/' + id + '/', {headers: loggedInHeaders});
  }

  /***
   ************************ End Gholname ************************
   */


  /***
   ************************ Users ************************
   */

  /***
   *
   * @param username
   * @param password
   * @returns {Observable<Response>}
   */
  login(username, password) {
    return this.http.post(this.serverAddress + '/users/login/',
      {
        username: username,
        password: password
      }
    );
  }

  /***
   *
   * @param name
   * @param codeMelli
   * @param page
   * @returns {Observable<Response>}
   */
  searchInUsers(name, codeMelli, page) {
    return this.http.post(this.serverAddress + '/users/search/?page=' + page,
      {
        name: name,
        code_melli: codeMelli,
      },
      {headers: loggedInHeaders});
  }

  /***
   *
   * @param user
   * @returns {Observable<Response>}
   */
  editUser(userId, user) {
    return this.http.put(this.serverAddress + '/users/show/' + userId + '/',
      {
        first_name: user.first_name,
        last_name: user.last_name,
        code_melli: user.code_melli,
        father: user.father,
        shomare_shenasname: user.shomare_shenasname,
        username: user.user_name,
        sadere: user.sadere,
        mobile_number: user.mobile_number,
        phone_number: user.phone_number,
        code_posti: user.code_posti,
        address: user.address,
      },
      {headers: loggedInHeaders});
  }

  getUser(userId) {
    return this.http.get(this.serverAddress + '/users/show/' + userId + '/',
      {headers: loggedInHeaders});
  }

  /***
   *
   * @param user
   * @returns {Observable<Response>}
   */
  createUser(user) {
    return this.http.post(this.serverAddress + '/users/management/',
      {
        first_name: user.first_name,
        last_name: user.last_name,
        code_melli: user.code_melli,
        father: user.father,
        shomare_shenasname: user.shomare_shenasname,
        username: user.user_name,
        sadere: user.sadere,
        mobile_number: user.mobile_number,
        phone_number: user.phone_number,
        code_posti: user.code_posti,
        address: user.address,
      },
      {headers: loggedInHeaders});
  }

  /***
   ************************ End Users ************************
   */

  /***
   ************************ Cars ************************
   */

  /***
   *
   * @param searchParams
   * @returns {Observable<Response>}
   */
  getCars(searchParams) {
    return this.http.get(this.serverAddress + '/cars/parking/list/' +
      '?page=' + searchParams.page +
      '&name=' + searchParams.name +
      '&model=' + searchParams.model +
      '&shasi=' + searchParams.shasi +
      '&system=' + searchParams.system,
      {headers: loggedInHeaders});
  }

  /***
   *
   * @param id
   * @returns {Observable<Response>}
   */
  /***
   *
   * @returns {Observable<Response>}
   */
  getcarTypes() {
    return this.http.get(this.serverAddress + '/cars/types/', {headers: loggedInHeaders});
  }

  /***
   *
   * @param carSystem
   * @returns {Observable<Response>}
   */
  getCarSystems(carSystem) {
    return this.http.get(this.serverAddress + '/cars/systems/' + carSystem + '/', {headers: loggedInHeaders});
  }

  /***
   *
   * @param carSystem
   * @returns {Observable<Response>}
   */
  getCarTips(carSystem) {
    return this.http.get(this.serverAddress + '/cars/tips/' + carSystem + '/', {headers: loggedInHeaders});
  }

  /***
   *
   * @param id
   * @returns {Observable<Response>}
   */
  getCar(id) {
    return this.http.get(this.serverAddress + '/cars/parking/car/' + id + '/', {headers: loggedInHeaders});
  }

  /***
   *
   * @returns {Observable<Response>}
   */
  getColors() {
    return this.http.get(this.serverAddress + '/cars/colors/', {headers: loggedInHeaders});
  }

  removeCost(id) {
    return this.http.delete(this.serverAddress + '/cars/parking/costs/' + id + '/', {headers: loggedInHeaders});
  }

  /**
   *
   * @param searchParams
   * @returns {Observable<Response>}
   */
  getParkingHistory(searchParams) {
    return this.http.get(this.serverAddress + '/cars/parking/history/' +
      '?page=' + searchParams.page +
      '&name=' + searchParams.name +
      '&code_melli=' + searchParams.code_melli +
      '&pelak=' + searchParams.pelak +
      '&shasi=' + searchParams.shasi +
      '&model=' + searchParams.model +
      '&system=' + searchParams.system +
      '&datetime=' + searchParams.datetime,
      {headers: loggedInHeaders});
  }

  /***
   *
   * @param carId
   * @param newCar
   * @returns {Observable<Response>}
   */
  editCar(carId, newCar) {
    return this.http.put(this.serverAddress + '/cars/parking/car/' + carId + '/', {
        color: newCar.color,
        model: newCar.model,
        motor: newCar.motor,
        name: newCar.name,
        pelak: newCar.pelak,
        shasi: newCar.shasi,
        system: newCar.system,
        tip: newCar.tip,
        vin: newCar.vin,
        bime_end_time: newCar.bime_end_time,
        takhfif_bime: newCar.takhfif_bime,
        kilometer: newCar.kilometer,
        moayene_end_time: newCar.moayene_end_time,
        fuel: newCar.fuel,
        description: newCar.description,
        color_details: newCar.color_details,
      },
      {headers: loggedInHeaders});
  }

  /***
   *
   * @param carId
   * @returns {Observable<Response>}
   */
  getCarExpenses(carId) {
    return this.http.get(this.serverAddress + '/cars/parking/costs/' + carId + '/',
      {headers: loggedInHeaders});
  }

  /***
   *
   * @param expens
   * @returns {Observable<Response>}
   */
  createExpenses(expens) {
    return this.http.post(this.serverAddress + '/cars/parking/car/' + expens.car_id + '/', {
        subject: expens.subject,
        amount: expens.amount,
        store: expens.store,
        description: expens.description
      },
      {headers: loggedInHeaders});
  }

  /***
   ************************ End Cars ************************
   */

  /***
   ************************ Archives ************************
   */
  getShomareBaygani() {
    return this.http.get(this.serverAddress + '/baygani/shomare_baygani/', {
      headers: loggedInHeaders
    });
  }

  /***
   *
   * @returns {Observable<Response>}
   */
  getArchivesList(searchParams) {
    console.log(searchParams);
    return this.http.get(this.serverAddress + '/baygani/list/' +
      '?page=' + searchParams.page +
      '&name=' + searchParams.name +
      '&vakil_id=' + searchParams.vakil_id +
      '&code_melli=' + searchParams.code_melli +
      '&shasi=' + searchParams.shasi +
      '&pelak_ghadim=' + searchParams.pelak_ghadim +
      '&pelak_jadid=' + searchParams.pelak_jadid +
      '&saheb_pelak_ghadim_id=' + searchParams.saheb_pelak_ghadim_id +
      '&khodro=' + searchParams.khodro +
      '&system=' + searchParams.system +
      '&model=' + searchParams.model +
      '&etmam_vekalat_kari=' + searchParams.etmam_vekalat_kari +
      '&etmam_vekalat_foro0sh=' + searchParams.etmam_vekalat_foro0sh,
      {headers: loggedInHeaders});
  }

  /***
   *
   * @param archiveId
   * @returns {Observable<Response>}
   */
  getArchiveDetails(archiveId) {
    return this.http.get(this.serverAddress + '/baygani/show/' + archiveId + '/', {headers: loggedInHeaders});
  }

  /**
   *
   * @param searchParams
   * @returns {Observable<Response>}
   */
  getMiscellaneousList(searchParams) {
    return this.http.get(this.serverAddress + '/baygani/motefarreghe/?' +
      'page=' + searchParams.page +
      '&type=' + searchParams.type +
      '&shomare_baygani=' + searchParams.shomare_baygani +
      '&subject=' + searchParams.subject,
      {headers: loggedInHeaders});
  }

  /***
   *
   * @param type
   * @param subject
   */
  createMiscellaneousTypical(archive) {
    return this.http.post(this.serverAddress + '/baygani/motefarreghe/',
      {
        type: archive.type,
        subject: archive.subject,
        description: archive.description
      },
      {headers: loggedInHeaders});
  }

  /***
   *
   * @param archive
   * @returns {Observable<Response>}
   */
  createMiscellaneusCar(archive) {
    return this.http.post(this.serverAddress + '/baygani/motefarreghe/',
      {
        type: archive.type,
        subject: archive.subject,
        system: archive.system,
        tip: archive.tip,
        model: archive.model,
        color: archive.color,
        pelak_ghadim: archive.pelak_ghadim,
        pelak_jadid: archive.pelak_jadid,
        shasi: archive.shasi,
        description: archive.description,
        enter_datetime: archive.enter_datetime,
        sanad_sabz: archive.sanad_sabz,
        sanad_company: archive.sanad_company,
        sanad_ghati: archive.sanad_ghati,
        taiidie_pelak: archive.taiidie_pelak,
        vekalat_kari: archive.vekalat_kari,
        vekalat_foro0sh: archive.vekalat_foro0sh,
        avArez_ta: archive.avArez_ta,
      }, {headers: loggedInHeaders});
  }

  /***
   *
   *
   * @param archive
   * @returns {Observable<Response>}
   */
  createArchive(archive) {
    return this.http.post(this.serverAddress + '/baygani/list/',
      {
        id: archive.id,
        current_state: archive.current_state,
        vekalat_kari_engheza: archive.vekalat_kari_engheza,
        sanad_dar_rahn_engheza: archive.sanad_dar_rahn_engheza,
        vekalat_foro0sh_engheza: archive.vekalat_foro0sh_engheza,
        sanad_sabz: archive.sanad_sabz,
        sanad_company: archive.sanad_company,
        sanad_ghati: archive.sanad_ghati,
        taiidie_pelak: archive.taiidie_pelak,
        vekalat_kari: archive.vekalat_kari,
        vekalat_foro0sh: archive.vekalat_foro0sh,
        avArez_ta: archive.avArez_ta,
        enter_datetime: archive.enter_datetime,
        tahvil_dahande_id: archive.tahvil_dahande_id,
        description: archive.description
      },
      {
        headers: loggedInHeaders
      });
  }

  /***
   *
   * @param enter
   * @returns {Observable<Response>}
   */
  enterArchive(enter) {
    return this.http.post(this.serverAddress + '/baygani/enter/' + enter.id + '/', {
      id: enter.id,
      sanad_sabz: enter.sanad_sabz,
      sanad_company: enter.sanad_company,
      sanad_ghati: enter.sanad_ghati,
      taiidie_pelak: enter.taiidie_pelak,
      vekalat_kari: enter.vekalat_kari,
      vekalat_foro0sh: enter.vekalat_foro0sh,
      avArez_ta: enter.avArez_ta,
      tahvil_dahande_id: enter.tahvil_dahande_id,
      description: enter.description,
      is_fak_rahn: enter.is_fak_rahn,
      datetime: enter.datetime,
    }, {headers: loggedInHeaders});
  }

  /***
   *
   * @param exit
   * @returns {Observable<Response>}
   */
  exitArchive(exit, isExitAvarezTa) {
    console.log(isExitAvarezTa);
    var AvarezTa = exit.avArez_ta;
    if (!isExitAvarezTa) {
      AvarezTa = '';
    }
    console.log(exit);
    return this.http.post(this.serverAddress + '/baygani/exit/' + exit.id + '/', {
      id: exit.id,
      sanad_sabz: exit.sanad_sabz,
      sanad_company: exit.sanad_company,
      sanad_ghati: exit.sanad_ghati,
      taiidie_pelak: exit.taiidie_pelak,
      vekalat_kari: exit.vekalat_kari,
      need_to_reminder: exit.need_to_reminder,
      ellat: exit.ellat,
      vekalat_foro0sh: exit.vekalat_foro0sh,
      avArez_ta: AvarezTa,
      bargasht_ehtemali_datetime: exit.bargasht_ehtemali_datetime,
      tahvil_girande_id: exit.tahvil_girande_id,
      description: exit.description,
      datetime: exit.datetime
    }, {headers: loggedInHeaders});
  }

  editArchive(editParams) {
    return this.http.put(this.serverAddress + '/baygani/show/' + editParams.id + '/',
      editParams
      , {headers: loggedInHeaders});
  }

  getMiscellaneousDocument(docId) {
    return this.http.get(this.serverAddress + '/baygani/sanad-motefarreghe/' + docId + '/'
      , {headers: loggedInHeaders});
  }

  getMiscellaneousCarDocument(docId) {
    return this.http.get(this.serverAddress + '/baygani/sanad-motefarreghe-mashin/' + docId + '/'
      , {headers: loggedInHeaders});
  }

  editMiscellaneousDocument(document) {
    return this.http.put(this.serverAddress + '/baygani/sanad-motefarreghe/' + document.id + '/', {
      subject: document.subject,
      description: document.description,
    }, {headers: loggedInHeaders});
  }

  editMiscellaneousCarDocument(document) {
    return this.http.put(this.serverAddress + '/baygani/sanad-motefarreghe-mashin/' + document.id + '/', {
      subject: document.subject,
      system: document.system,
      tip: document.tip,
      model: document.model,
      color: document.color,
      pelak_ghadim: document.pelak_ghadim,
      pelak_jadid: document.pelak_jadid,
      shasi: document.shasi,
      description: document.description,
      sanad_sabz: document.madarek_tahvili.sanad_sabz,
      sanad_company: document.madarek_tahvili.sanad_company,
      sanad_ghati: document.madarek_tahvili.sanad_ghati,
      taiidie_pelak: document.madarek_tahvili.taiidie_pelak,
      vekalat_kari: document.madarek_tahvili.vekalat_kari,
      vekalat_foro0sh: document.madarek_tahvili.vekalat_foro0sh,
    }, {headers: loggedInHeaders});
  }

  deleteMiscellaneousDocument(document) {
    return this.http.delete(this.serverAddress + '/baygani/sanad-motefarreghe/' + document.id + '/'
      , {headers: loggedInHeaders});
  }

  deleteMiscellaneousCarDocument(document) {
    return this.http.delete(this.serverAddress + '/baygani/sanad-motefarreghe-mashin/' + document.id + '/'
      , {headers: loggedInHeaders});
  }


  /***
   ************************ End Archives ************************
   */

  getDaftarKolls() {
    return this.http.get(this.serverAddress + '/accounting/dafater_kol/', {headers: loggedInHeaders});
  }

  setDaftarKolls(data: any) {
    console.log(data);
    return this.http.put(this.serverAddress + '/accounting/dafater_kol/', data, {headers: loggedInHeaders});
  }

  newDaftarKolls(data: DaftarKol) {
    return this.http.post(this.serverAddress + '/accounting/dafater_kol/', data, {headers: loggedInHeaders});
  }


  getDaftarKollDetail(id: number, search) {
    return this.http.get(
      this.serverAddress + '/accounting/dafater_kol/' + id + '/',
      {
        headers: loggedInHeaders,
        params: search
      }
    );
  }


  deleteDaftarKolls(id: number) {
    return this.http.delete(
      this.serverAddress + '/accounting/dafater_kol/' + id + '/',
      {headers: loggedInHeaders}
    );
  }

  getBanks() {
    return this.http.get(this.serverAddress + '/accounting/banks/',
      {headers: loggedInHeaders});
  }

  newBank(name: string) {
    return this.http.post(this.serverAddress + '/accounting/banks/',
      {'name': name},
      {headers: loggedInHeaders});
  }


  /***
   ************************ Start Talab Bedeh ************************
   */

  createTalabkar(params: TalBed) {
    return this.http.post(this.serverAddress + '/accounting/talabkar/',
      params, {headers: loggedInHeaders});
  }

  createBedehkarkar(params: TalBed) {
    return this.http.post(this.serverAddress + '/accounting/bedehkar/',
      params, {headers: loggedInHeaders});
  }

  getChekList(params: { [key: string]: any | any[]; } | null) {
    return this.http.get(this.serverAddress + '/accounting/cheks/', {
      headers: loggedInHeaders,
      params: params
    });
  }

  getHesabDaftarKols(only = false) {
    return this.http.get(this.serverAddress + '/accounting/hesba_daftar_kols/?d=' + (only ? '0' : '1'), {headers: loggedInHeaders});
  }

  getAllHesabDaftarKols() {
    return this.http.get(this.serverAddress + '/accounting/hesba_daftar_kol/', {headers: loggedInHeaders});
  }

  setHesabDaftarKols(data: HesabDaftarKol) {
    return this.http.put(this.serverAddress + '/accounting/hesba_daftar_kols/', data, {headers: loggedInHeaders});
  }

  newHesabDaftarKols(data: HesabDaftarKol) {
    return this.http.post(this.serverAddress + '/accounting/hesba_daftar_kols/', data, {headers: loggedInHeaders});
  }

  createDaryaftAzTarafHesab(data: DaryaftAzTarafHesabParams) {
    return this.http.post(this.serverAddress + '/accounting/daryaft_az_taraf_hesab/', data, {headers: loggedInHeaders});
  }

  createPardakhtBeTarafHesab(data: PardakhtBeTarafHesabParams) {
    return this.http.post(this.serverAddress + '/accounting/pardakht_be_taraf_hesab/', data, {headers: loggedInHeaders});
  }

  getSandogh(params: { [key: string]: any | any[]; }) {
    return this.http.get(this.serverAddress + '/accounting/sandogh/', {
      headers: loggedInHeaders,
      params: params
    });
  }

  newTransfer(data: any) {
    return this.http.post(this.serverAddress + '/accounting/transfers/', data, {headers: loggedInHeaders});
  }

  getHesabDaftariDetail(s: {}) {
    return this.http.get(this.serverAddress + '/accounting/hesba_daftari/', {
      headers: loggedInHeaders,
      params: s
    });
  }

  chek_status(action: number, id: number, dt: { a0: null; a1: null; a2: null; a3: null }) {
    return this.http.post(this.serverAddress + '/accounting/chek/' + id + '/', {
      'action': action,
      'data_1': dt.a0,
      'data_2': dt.a1,
      'data_3': dt.a2,
      'data_4': dt.a3,
    }, {
      headers: loggedInHeaders
    });
  }

  chek_edit(action: number, chek: ChekDataInterface) {
    return this.http.put(this.serverAddress + '/accounting/chek/' + chek.id + '/', {
      'mablagh': chek.mablagh,
      'code': chek.code,
      'dar_vajh': chek.dar_vajh,
      'saheb_hesab': chek.saheb_hesab,
      'shomare_hesab': chek.shomare_hesab,
      'shomare_chek': chek.shomare_chek,
      'tarikh_sarresid': chek.tarikh_sarresid
    }, {
      headers: loggedInHeaders
    });

  }

  saveCar(param: { code: any; vin: any | string; id: any }) {
    return this.http.put(this.serverAddress + '/cars/savecar/', param, {
      headers: loggedInHeaders
    });
  }

  getHesabDaftariDaily(s: any) {
    return this.http.get(this.serverAddress + '/accounting/daily/', {
      headers: loggedInHeaders,
      params: s
    });
  }

  deleteHesabDaftariDaily(id: number, b: boolean, txt: string) {
    return this.http.put(this.serverAddress + '/accounting/daily/', {
      'id': id,
      'all': b,
      'desc': txt
    }, {
      headers: loggedInHeaders
    });
  }

  getPardakht(id: any) {
    return this.http.get(this.serverAddress + '/accounting/pardakht_be_taraf_hesab/', {
      headers: loggedInHeaders,
      params: {
        'id': id
      }
    });
  }

  getDaryaft(id: any) {
    return this.http.get(this.serverAddress + '/accounting/daryaft_az_taraf_hesab/', {
      headers: loggedInHeaders,
      params: {
        'id': id
      }
    });
  }

  getTalab(id: any) {
    return this.http.get(this.serverAddress + '/accounting/talabkar/', {
      headers: loggedInHeaders,
      params: {
        'id': id
      }
    });
  }

  getBedeh(id: any) {
    return this.http.get(this.serverAddress + '/accounting/bedehkar/', {
      headers: loggedInHeaders,
      params: {
        'id': id
      }
    });
  }
}

