import {Injectable} from '@angular/core';
import {MatSnackBar} from '@angular/material';
import {Mds} from 'mds.persian.datetime';
import {NgxPersianNumbersService} from '../../../node_modules/ngx-persian-number/src/services/ngx-persian-numbers.service';
import PersianDateTime = Mds.PersianDateTime;

@Injectable()
export class AppService {
  /***
   *
   *
   * @param {MatSnackBar} snackbar
   */
  constructor(public snackbar: MatSnackBar, public ngxNum: NgxPersianNumbersService) {

  }

  /***
   *
   * @param message
   */
  showSnackbar(message) {
    this.snackbar.open(message, undefined, {duration: 1500});
  }

  mdstimstampToJalali = function (timestamp = null) {
    if (timestamp === null) {
      return new PersianDateTime(new Date());
    }
    let pt = new PersianDateTime(new Date(timestamp));
    return (pt);
  };

  calcMablaghGhests(totalCost, ghestNum, precentNum) {
    const x = Number(this.ngxNum.removeLettersFromString(totalCost));
    const y = Number(precentNum);
    const z = Number(ghestNum);
    console.log(x, y, z);

    let res;

    if (y < 4.5) {
      res = x * (y * z + 100) / (100 * z);
    } else {
      res = x * (y * (z + 1) + 200) / (200 * z);
    }
    return res;
  }

  calcAlbaghi(totalCost, pishPardakht) {
    totalCost = +this.ngxNum.removeLettersFromString(totalCost);
    pishPardakht = +this.ngxNum.removeLettersFromString(pishPardakht);
    const remain = totalCost - pishPardakht;

    if (remain >= 0) {
      return remain;
    }
  }
}
