import {Pipe, PipeTransform} from '@angular/core';
import {Mds} from 'mds.persian.datetime';
import PersianDateTime = Mds.PersianDateTime;

@Pipe({
  name: 'timeStampToJalai'
})

export class TimeStampToJalaiPipe implements PipeTransform {
  /***
   *
   * @param value
   * @param time
   * @returns {any}
   */
  transform(value: any, time?: any): any {
    const date = new PersianDateTime(new Date(value * 1000));

    if (time) {
      return date.hour + ':' + date.minute + ':' + date.second;
    }

    return date.year + '/' + date.month + '/' + date.day;
  }

}
