import {Params} from '@angular/router';
import {hasOwnProperty} from 'tslint/lib/utils';

export class User {
  first_name: string = '';
  last_name: string = '';
  code_melli: any;
  father: string;
  shomare_shenasname: any;
  sadere: string;
  mobile_number: '';
  phone_number: '';
  code_posti: '';
  address: '';
  user_name;
}

export interface UserInterface {
  first_name: string;
  last_name: string;
  code_melli: any;
  father: string;
  shomare_shenasname: any;
  sadere: string;
  mobile_number: string;
  phone_number: string;
  code_posti: string;
  address: string;
  user_name: string;
}

export class gholnameNaghdi {
  car_id;
  gholname_datetime;
  tahvil_datetime;
  total_cost;
  pish_pardakht;
  kharj_sanad;
  dong;
  kharidar_id;
  foro0shande_id;
  description;
  main_cost;
}

export class gholnameKharidNamayeshgah {
  name;
  pish_pardakht;
  color;
  tip;
  model;
  motor;
  shasi;
  gholname_datetime;
  pelak;
  total_cost;
  tahvil_datetime;
  kharj_sanad;
  saheb_pelak_id;
  dong;
  description;
  code;
  shomare_dasti;
  kharidar_id;
  foro0shande_id;
  VIN;
  vin;
  system;
  main_cost;
}

export class gholnameAghsati {
  car_id;
  gholname_datetime;
  tahvil_datetime;
  total_cost;
  pish_pardakht;
  kharj_sanad;
  dong;
  kharidar_id;
  foro0shande_id;
  description;
  ghest_num;
  percent_num;
  ghest_start_datetime;
  mablagh_e_ghest;
  main_cost;
}

export class car {
  color;
  model;
  motor;
  name;
  pelak;
  shasi;
  system;
  tip;
  vin;
  bime_end_time;
  takhfif_bime;
  kilometer;
  moayene_end_time;
  fuel;
  color_details;
}

export class gholnameSearchParams {
  name = '';
  code_melli = '';
  system = '';
  pelak_ghadim = '';
  pelak_jadid = '';
  motor = '';
  shasi = '';
  type = '';
  types_kharid_namayeshgah = false;
  types_naghdi = false;
  types_aghsati = false;
  types_sefr_aghsati = false;
  types_sefr_naghdi = false;
  types_sefr_lizing = false;
  types_is_faskh = false;
  page = 1;

  public reset() {
    this.name = '';
    this.code_melli = '';
    this.system = '';
    this.pelak_ghadim = '';
    this.pelak_jadid = '';
    this.motor = '';
    this.shasi = '';
    this.type = '';
    this.types_kharid_namayeshgah = false;
    this.types_naghdi = false;
    this.types_aghsati = false;
    this.types_sefr_aghsati = false;
    this.types_sefr_naghdi = false;
    this.types_sefr_lizing = false;
    this.types_is_faskh = false;
    this.page = 1;
  }

  import(queryParams: Params) {
    if (hasOwnProperty(queryParams, 'name')) {
      this.name = queryParams['name'];
    }
    if (hasOwnProperty(queryParams, 'code_melli')) {
      this.code_melli = queryParams['code_melli'];
    }
    if (hasOwnProperty(queryParams, 'system')) {
      this.system = queryParams['system'];
    }
    if (hasOwnProperty(queryParams, 'pelak_ghadim')) {
      this.pelak_ghadim = queryParams['pelak_ghadim'];
    }
    if (hasOwnProperty(queryParams, 'pelak_jadid')) {
      this.pelak_jadid = queryParams['pelak_jadid'];
    }
    if (hasOwnProperty(queryParams, 'motor')) {
      this.motor = queryParams['motor'];
    }
    if (hasOwnProperty(queryParams, 'shasi')) {
      this.shasi = queryParams['shasi'];
    }
    if (hasOwnProperty(queryParams, 'type')) {
      this.type = queryParams['type'];
    }
    if (hasOwnProperty(queryParams, 'types_kharid_namayeshgah')) {
      this.types_kharid_namayeshgah = queryParams['types_kharid_namayeshgah'] === 'true';
    }
    if (hasOwnProperty(queryParams, 'types_naghdi')) {
      this.types_naghdi = queryParams['types_naghdi'] === 'true';
    }
    if (hasOwnProperty(queryParams, 'types_aghsati')) {
      this.types_aghsati = queryParams['types_aghsati'] === 'true';
    }
    if (hasOwnProperty(queryParams, 'types_sefr_aghsati')) {
      this.types_sefr_aghsati = queryParams['types_sefr_aghsati'] === 'true';
    }
    if (hasOwnProperty(queryParams, 'types_sefr_naghdi')) {
      this.types_sefr_naghdi = queryParams['types_sefr_naghdi'] === 'true';
    }
    if (hasOwnProperty(queryParams, 'types_sefr_lizing')) {
      this.types_sefr_lizing = queryParams['types_sefr_lizing'] === 'true';
    }
    if (hasOwnProperty(queryParams, 'types_is_faskh')) {
      this.types_is_faskh = queryParams['types_is_faskh'] === 'true';
    }
    if (hasOwnProperty(queryParams, 'page')) {
      this.page = +queryParams['page'];
    }
  }
}

export class chekSearchParams {
  sarresid_az = '';
  sarresid_ta = '';
  chek_id = '';
  daryaft_konnade_id = '';
  babat = '';
  bank = '';
  type = '';
  t = null;
  page = 1;
}

export class carsSearchParams {
  name = '';
  model = '';
  shasi = '';
  system = '';
  page = 1;
}

export class expens {
  car_id;
  subject;
  amount;
  store;
  description;
}

export class gholnameSefrNaghdi {
  name;
  system;
  tip;
  model;
  color;
  pelak;
  shasi;
  motor;
  gholname_datetime;
  tahvil_datetime;
  total_cost;
  pish_pardakht;
  kharj_sanad;
  dong;
  saheb_pelak_id;
  kharidar_id;
  manba_kharid_id;
  foro0shande_id;
  description;
  shomare_dasti;
  code;
  VIN;
  vin;
  main_cost;
}

export class gholnameSefrAghsati {
  name;
  system;
  tip;
  model;
  color;
  pelak;
  shasi;
  motor;
  gholname_datetime;
  tahvil_datetime;
  total_cost;
  pish_pardakht;
  kharj_sanad;
  dong;
  saheb_pelak_id;
  kharidar_id;
  manba_kharid_id;
  foro0shande_id;
  description;
  shomare_dasti;
  code;
  VIN;
  vin;
  ghest_num;
  percent_num;
  ghest_start_datetime;
  main_cost;
}

export class gholnameSefrLizing {
  name;
  system;
  tip;
  model;
  color;
  pelak;
  shasi;
  motor;
  gholname_datetime;
  tahvil_datetime;
  total_cost;
  pish_pardakht;
  kharj_sanad;
  dong;
  kharidar_id;
  manba_kharid_id;
  foro0shande_id;
  description;
  chek_num;
  moddat_check;
  main_cost;
}

export class ArchivesSearchParams {
  page = 1;
  name = '';
  code_melli = '';
  shasi = '';
  pelak_ghadim = '';
  pelak_jadid = '';
  saheb_pelak_ghadim_id = '';
  vakil_id = '';
  khodro = '';
  etmam_vekalat_foro0sh = '';
  etmam_vekalat_kari = '';
  system = '';
  model = '';
}

export class carInArchive {
  name;
  model;
  shasi;
}

export class Archive {
  car = new carInArchive();
  current_state;
  vekalat_kari_engheza;
  sanad_dar_rahn_engheza;
  vekalat_foro0sh_engheza;
  sanad_sabz;
  sanad_company;
  sanad_ghati;
  taiidie_pelak;
  vekalat_kari;
  vekalat_foro0sh;
  avArez_ta;
  enter_datetime;
  tahvil_dahande_id;
  description;
  kharidar;
  foro0shande;
  tahvil_dahande;
}

export class EnterArchive {
  id;
  sanad_sabz;
  sanad_company;
  sanad_ghati;
  taiidie_pelak;
  vekalat_kari;
  vekalat_foro0sh;
  avArez_ta;
  tahvil_dahande_id;
  description;
  is_fak_rahn;
  datetime;
  ellat;
}

export class ExitArchive {
  id;
  sanad_sabz;
  sanad_company;
  sanad_ghati;
  taiidie_pelak;
  vekalat_kari;
  vekalat_foro0sh;
  avArez_ta;
  avArez_ta_date;
  tahvil_girande_id;
  description = '';
  bargasht_ehtemali_datetime;
  ellat;
  datetime;
  need_to_reminder;
}

export class MiscellaneousTypical {
  type = 'typical';
  subject;
  description;
}

export class MiscellaneousCar {
  type = 'car_sanad';
  subject;
  system;
  tip;
  model;
  color;
  pelak_ghadim;
  pelak_jadid;
  shasi;
  description;
  enter_datetime;
  sanad_sabz;
  sanad_company;
  sanad_ghati;
  taiidie_pelak;
  vekalat_kari;
  vekalat_foro0sh;
  avArez_ta;
  idOfkindOfCar;
  systemId;
}

export class MiscellenousSearchParams {
  page = 1;
  type = '';
  subject = '';
  shomare_baygani = '';
}

export class FaskhGholname {
  id;
  faskh_datetime;
  sabt_datetime;
  description;
}

export class EditArchive {
  id;
  current_state;
  vakil_id;
  vekalat_kari_engheza;
  vekalat_foro0sh_engheza;
  description;
  sanad_dar_rahn_engheza;
}

export class HistorySearchParams {
  page = 1;
  name = '';
  code_melli = '';
  pelak = '';
  shasi = '';
  datetime = '';
  model = '';
  system = '';
}

export enum Jahat {
  kharidKhodro = 'KHARID_KHODRO',
  hesabDaftari = 'HESAB_DAFTARI',
  daftarKol = 'DAFTAR_KOL',
  eslahieHesabDaftaro = 'ESLAHIE_HESAB_DAFTARI',
  eslahieDaftarKol = 'ESLAHIE_DAFTAR_KOL',
  faghatHesabDaftari = 'FAGHAT_HESAB_DAFTARI'
}


export enum ChekStatus {
  DELETE = 0,
  VOSUL = 1,
  RETURN = 2,
  PASS = 3,
  DELAY = 4,
  EDIT = 5
}

export interface ChekInterface {
  bank: BankInterface;
  bank_id: number;
  hesab: string;
  dar_vajh: string;
  number: string;
  code: string;
  shobe: string;
  sub_hesab: string;
  tarikh: number;
  amount: number;
}

export interface ChekDataInterface {
  id: number;
  tarikh_sarresid: number;
  tarikh_pardakht: number;
  bank: BankInterface
  shomare_chek: string;
  dar_vajh: string;
  code: string;
  shobe: string;
  shomare_hesab: string;
  saheb_hesab: string;
  mablagh: number;
  daryafti: DaryaftAzTarafHesabParams;
  pardakhti: PardakhtBeTarafHesabParams;
  is_self: boolean;
  types?: boolean[];
  tozihats?: string[];
}

export interface BankInterface {
  id: number;
  name: string;
}

export interface MinimalSandogh {
  amel: UserInterface;
  tavassot: UserInterface;
  bAbat: string;
  sign: boolean;
  tozihat: string;
  jahat: any;
  amount: number;
  pos_amount: number;
  cash_amount: number;
  card_amount: number;
  chek_amount: number;
  created_at: number;
  // cheks?: ChekDataInterface[];
  tarigh: number | null;
  tarigh_txt: string;
  bank?: string;
  carmozd: number;
}

export interface MinimalHesab extends MinimalSandogh {
  type_of: number;
  id: number;
  tpl: number;
  deleted: boolean;
  sarresid: number[];
}

export interface GhestOfHesabDaftari {
  talab_bedeh: {
    shakhs: {
      id: number;
      first_name: string;
      last_name: string;
      father: string;
      code_melli: string;
    };
    babat: string;
    amount: number;
    tarikh_sabt: number;
    id: number;
    tozihat: string;
    is_talab: boolean;
  };
  id: number;
  num: number;
  amount: number;
  tarikh_daryaft: number;
  tarikh_amal: number;
}

export const checkTypes: {
  status: number,
  value: string,
  icon: string
}[] = [
  {
    'status': ChekStatus.DELAY,
    'value': 'تعویق',
    'icon': 'close'
  },
  {
    'status': ChekStatus.DELETE,
    'value': 'حذف',
    'icon': 'delete'
  },
  {
    'status': ChekStatus.PASS,
    'value': 'پاس',
    'icon': 'euro_symbol'
  },
  {
    'status': ChekStatus.RETURN,
    'value': 'برگشت',
    'icon': 'forum'
  },
  {
    'status': ChekStatus.VOSUL,
    'value': 'وصول',
    'icon': 'touch_app'
  },
  {
    'status': ChekStatus.EDIT,
    'value': 'اصلاح',
    'icon': 'print'
  }
];

export interface Cars {
  id: number;
  name: string;
  system: string;
  tip: string;
  model: string;
  color: string;
  pelak: string;
  shasi: string;
  motor: string;
  code: string;
  vin: string;
  gholname: {
    kharidar: UserInterface | null;
    foro0shande: UserInterface | null;
  }[];
}

export interface DaryaftAzTarafHesabParams {
  id?: number;
  pardakht_konande_id: number;
  pardakht_konande?: UserInterface;
  tavassot_id: number;
  tavassot?: UserInterface;
  tarikh_daryaft: number;
  jahat: Jahat;
  babat: string;
  bAbat?: string;
  tozihat: string;
  daftar_kol_id: number;
  hesab_daftar_kol_id: number;
  hesab_daftar_kol?: HesabDaftarKol;
  pos_amount: number;
  cash?: number;
  card_amount: number;
  cash_amount: number;
  cheks?: ChekInterface[];
  created_at?: number;
}

export interface PardakhtBeTarafHesabParams {
  id?: number;
  daryaft_konande_id: number;
  daryaft_konande?: UserInterface;
  tavassot_id: number;
  tavassot?: UserInterface;
  tarikh_daryaft: number;
  tarikh_pardakht?: number;
  jahat: Jahat;
  babat: string;
  bAbat?: string;
  tozihat: string;
  daftar_kol_id: number;
  hesab_daftar_kol_id: number;
  hesab_daftar_kol?: HesabDaftarKol;
  pos_amount: number;
  card_amount: number;
  carmozd: number;
  cash_amount: number;
  cash?: number;
  ashkhas_cheks: number[];
  cheks?: ChekInterface[];
  created_at?: number;
}

export interface TalBed {
  id: number;
  shaks_id: number;
  babat: string;
  amount: number;
  num: number;
  qnum: number;
  num_type: string;
  tarikh_sabt: number;
  tarikh_daryaft: number;
  tozihat: string;
}

export interface MiniHesabDaftarKol {
  id: number;
  name: string;
  banks: BankInterface[];
}

export interface HesabDaftarKol {
  id: number;
  name: string;
  has_chek: boolean;
  has_pos: boolean;
  has_card: boolean;
  bank: BankInterface;
  shobe: string;
  code_shobe: string;
  shomare_hesab: string;
  telephone: string;
  saheb_hesab: string;
  tozihat: string;
}

export interface DaftarKol {
  id: number;
  name: string;
  hesabdaftarkol_set: HesabDaftarKol[];
}


export interface Sandogh {
  id: number;
  pardakht_konande?: any;
  daryaft_konande?: any;
  tavassot: any;
  tarikh_daryaft?: any;
  tarikh_pardakht?: any;
  jahat: Jahat;
  hesab_daftar_kol: any;
  bAbat: any;
  tozihat: any;
  cash: any;
}
