import {Injectable} from '@angular/core';
import {CanActivate, ActivatedRouteSnapshot, RouterStateSnapshot, Router, ActivatedRoute} from '@angular/router';

@Injectable()
export class AuthGuard implements CanActivate {

  userIsLoggedIn: boolean;

  constructor(public router: Router, public route: ActivatedRoute) {
  }

  canActivate(route: ActivatedRouteSnapshot,
              state: RouterStateSnapshot): boolean {
    this.userIsLoggedIn = localStorage.getItem('token') !== null;

    if (this.userIsLoggedIn) {

    } else {
      this.router.navigate(['/user/login'], {queryParams: {next: state.url}});
    }

    return true;
  }
}
