import {Directive, ElementRef, HostListener, Input} from '@angular/core';
import {Renderer2} from '@angular/core';

@Directive({
  selector: '[appAutoTab]'
})
export class AutoTabDirective {
  public maxLength;
  @Input() next;
  public el;

  constructor(el: ElementRef, public render: Renderer2) {
    this.el = el.nativeElement;
    this.maxLength = this.el.getAttribute('maxlength');
  }

  @HostListener('ngModelChange', ['$event'])
  getValue(value) {
    // console.log(value, this.maxLength);
    if (value.length == this.maxLength) {
      this.next.focus();
    }
  }


}
