import {Component, EventEmitter, Input, OnInit, Output} from '@angular/core';
import {MatDialog} from '@angular/material';
import {User} from '../../../../interfaces';
import {SearchUsersComponent} from '../search-users/search-users.component';

@Component({
  selector: 'app-show-selected-user',
  templateUrl: './show-selected-user.component.html',
  styleUrls: ['./show-selected-user.component.css']
})
export class ShowSelectedUserComponent implements OnInit {
  @Input() userType = '';
  @Output() onSelectedUser: EventEmitter<any> = new EventEmitter;
  @Output() profile: EventEmitter<any> = new EventEmitter;
  @Input() defaultUser;
  public user = new User();
  public userTitle;

  constructor(public dialog: MatDialog) {

  }

  openUserModal() {
    const userModal = this.dialog.open(SearchUsersComponent);
    userModal.afterClosed().subscribe(
      (user) => {
        if (user) {
          this.setUserData(user.data);
        }
      }
    );

  }

  setUserData(info) {
    this.user = info;
    this.profile.emit(info.first_name + '' + info.last_name);
    this.onSelectedUser.emit(info.id);
  }

  ngOnInit() {
    // console.log(this.userType);

    if (this.defaultUser) {
      this.user = this.defaultUser;
    }

    switch (this.userType) {
      case 'seller': {
        this.userTitle = 'فروشنده';
        // console.log('a');
        break;
      }
      case 'tahvilDahande': {
        this.userTitle = 'تحویل دهنده';
        break;
      }
      case 'maanba_khrid': {
        this.userTitle = 'منبع خرید';
        break;
      }
      case 'buyer': {
        this.userTitle = 'خریدار';
        break;
      }

      case 'vakil': {
        this.userTitle = 'وکیل';
        break;
      }

      case 'sahebPelak': {
        this.userTitle = 'صاحب پلاک';
        break;
      }
      case 'sahebPelakGhadim': {
        this.userTitle = 'صاحب پلاک قدیم ';
        break;
      }
      case 'tahvilGirande': {
        this.userTitle = 'تحویل گیرنده';
        break;
      }
      case 'pardakhtKonande': {
        this.userTitle = 'پرداخت کننده';
        break;
      }
      case 'tavasot': {
        this.userTitle = 'توسط';
        break;
      }
    }
  }

}
