import {Component, EventEmitter, Input, OnInit, Output} from '@angular/core';
import {SelectcarComponent} from '../selectcar/selectcar.component';
import {MatDialog} from '@angular/material';
import {car} from '../../../../interfaces';
import {ConnectorService} from '../../../../services/connector.service';

@Component({
  selector: 'app-show-selected-car',
  templateUrl: './show-selected-car.component.html',
  styleUrls: ['./show-selected-car.component.css']
})
export class ShowSelectedCarComponent implements OnInit {
  public car;
  @Input() defaultCar;
  @Output() onSelectCar: EventEmitter<any> = new EventEmitter();

  constructor(public dialog: MatDialog, private cs: ConnectorService) {
  }


  setUserData(car) {
    this.car = car;
    this.onSelectCar.emit(car.id);
  }

  setNewPelak(pelak) {
    this.car.pelak = pelak;
  }

  openSelectCarModal() {
    const modal = this.dialog.open(SelectcarComponent, {minWidth: '424px'});

    modal.afterClosed().subscribe(
      (car) => {
        if (car) {
          this.setUserData(car);
        }
      }
    );

  }

  ngOnInit() {
    // console.log(this.defaultCar);
    this.car = this.defaultCar ? this.defaultCar : new car();
  }

  save() {
    this.cs.saveCar({
      'id': this.car.id,
      'vin': this.car.vin,
      'code': this.car.code,
    }).subscribe(
      () => {

      }
    );
  }

}
