import {Component, OnInit} from '@angular/core';
import {ConnectorService} from '../../../../services/connector.service';
import {MatDialogRef} from '@angular/material';
import {carsSearchParams} from '../../../../interfaces';

@Component({
  selector: 'app-selectcar',
  templateUrl: './selectcar.component.html',
  styleUrls: ['./selectcar.component.css']
})
export class SelectcarComponent implements OnInit {
  public carsList = [];
  public isLoading;
  public numOfPages;
  public searchParams = new carsSearchParams();

  constructor(public cs: ConnectorService, public dialog: MatDialogRef<any>) {
  }

  getCarsList(page) {
    this.searchParams.page = page;
    this.isLoading = true;
    this.cs.getCars(this.searchParams)
      .subscribe(
        (response) => {
          this.isLoading = false;
          this.carsList = response.json().cars;
          this.numOfPages = response.json().num_of_pages;
          // console.log(response.json());
        },
        (error) => {
          // console.log(error);
        }
      );
  }

  selectCar(car) {
    this.dialog.close(car);
  }

  changePage(i) {
    this.getCarsList(i);
  }

  ngOnInit() {
    this.getCarsList(1);
  }

}
