import {Component, EventEmitter, OnInit, Output} from '@angular/core';
import {ConnectorService} from '../../../../services/connector.service';
import {ArchivesSearchParams} from '../../../../interfaces';
import {MatDialogRef} from '@angular/material';

@Component({
  selector: 'app-select-archive',
  templateUrl: './select-archive.component.html',
  styleUrls: ['./select-archive.component.css']
})

export class SelectArchiveComponent implements OnInit {
  public archivesList;
  public isLoading;
  public numOfPages;
  public searchParams = new ArchivesSearchParams();
  public page;
  nameKeyword;
  @Output() onArchiveSelected: EventEmitter<any> = new EventEmitter();

  constructor(public cs: ConnectorService, public dialog: MatDialogRef<any>) {
  }

  getArichivesList(page: number = 1 , name?: any) {
    this.isLoading = true;
    this.cs.getKharidVaForoshList(page , name).subscribe(
      (response) => {
        this.archivesList = response.json().baygani;
        this.numOfPages = response.json().num_of_pages;
        this.isLoading = false;
        // console.log(this.archivesList);
      },
      (error) => {
        // console.log(error);
      }
    );
  }

  searchArchive(name) {
    this.getArichivesList(1, name);
  }
  selectArchive(archive) {
    this.dialog.close(archive);
  }

  onPageChange(page) {
    this.page = page;
    this.getArichivesList(this.page);
  }

  ngOnInit() {
    this.getArichivesList();
  }

}
