import {Component, OnInit} from '@angular/core';
import {ConnectorService} from '../../../../services/connector.service';
import {MatDialogRef} from '@angular/material';
import {gholnameSearchParams} from '../../../../interfaces';

@Component({
  selector: 'app-search-users',
  templateUrl: './search-users.component.html',
  styleUrls: ['./search-users.component.css']
})
export class SearchUsersComponent implements OnInit {
  searchParams = new gholnameSearchParams();

  constructor(public cs: ConnectorService, public dialog: MatDialogRef<any>) {
  }

  public name;
  public code_melli;
  public isLoading;
  public searchResult = [];
  public numOfPages;

  searchInUsers(page = 1) {
    this.isLoading = true;
    this.cs.searchInUsers(this.name, this.code_melli, page).subscribe(
      (response) => {
        this.isLoading = false;
        this.searchResult = response.json().users;
        this.numOfPages = response.json().num_of_pages;
        // console.log(response.json());
      },
      (error) => {
        // console.log(error);
      }
    );

  }

  changePage(i) {
    this.searchInUsers(i);
  }

  selectUser(user) {
    this.dialog.close({data: user});
  }

  ngOnInit() {
    this.searchInUsers(1);
  }

}
