import {Component, OnInit} from '@angular/core';
import {ConnectorService} from '../../../../services/connector.service';
import {MatDialogRef} from '@angular/material';
import {MiniHesabDaftarKol} from '../../../../interfaces';

@Component({
  selector: 'app-search-bank',
  templateUrl: './search-bank.component.html',
  styles: [
    'img {width: 60px}',
    '.user:hover  {background: rgba(0, 0, 0, .12)}',
    '.user {transition: .5s;padding: 10px;cursor: pointer;direction: rtl;}'
  ]
})
export class SearchBankComponent implements OnInit {
  public isLoading;
  public hesabs: MiniHesabDaftarKol[] = [];

  public hesab_id: number = null;
  public bank_id: number = null;

  constructor(private cs: ConnectorService, private dialog: MatDialogRef<any>) {
  }

  get hesab() {
    return this.hesabs.find((el) => {
      return el.id === +this.hesab_id;
    });
  }

  selectBank() {
    this.dialog.close({
      hesab: this.hesab,
      bank: this.hesab.banks.find((el) => {
        return el.id === +this.bank_id;
      })
    });
  }

  ngOnInit() {
    this.isLoading = true;
    this.cs.getAllHesabDaftarKols().subscribe(
      (res) => {
        this.hesabs = res.json();
        this.isLoading = false;
      }
    );
  }
}
