import {Component, EventEmitter, Input, OnInit, Output} from '@angular/core';
import {ConnectorService} from '../../../../../services/connector.service';

@Component({
  selector: 'app-select-type',
  templateUrl: './select-type.component.html',
  styleUrls: ['./select-type.component.css']
})
export class SelectTypeComponent implements OnInit {
  @Output() onSelectType: EventEmitter<any> = new EventEmitter<any>();
  public types;
  public isLoading;
  @Input() defalutType;

  constructor(public cs: ConnectorService) {
  }

  onSelectCar(value) {
    for (let type in this.types) {
      if (this.types[type].name == value.source.value) {
        this.onSelectType.emit({name: value.source.value, id: this.types[type].id});
      }
    }
  }

  getTypes() {
    this.isLoading = true;
    this.cs.getcarTypes().subscribe(
      (response) => {
        // console.log(response.json());
        this.types = response.json();
        this.isLoading = false;
      },
      (error) => {
        // console.log(error);
      }
    );
  }

  ngOnInit() {
    this.getTypes();
  }

}
