import {Component, EventEmitter, Input, OnInit, Output} from '@angular/core';
import {ConnectorService} from '../../../../../services/connector.service';

@Component({
  selector: 'app-select-tip',
  templateUrl: './select-tip.component.html',
  styleUrls: ['./select-tip.component.css']
})
export class SelectTipComponent implements OnInit {
  @Input() type;
  public tips;
  public isLoading;
  public selectedTip;
  @Output() onSelectTip: EventEmitter<any> = new EventEmitter<any>();

  @Input() set value(value) {
    // console.log('value', value);
    if (value) {
      this.getTips();
      this.selectedTip = value;
    }
  }

  constructor(public cs: ConnectorService) {
  }

  onSelectTip1(tip) {
    this.onSelectTip.emit(tip);
  }

  getTips() {
    this.isLoading = true;
    this.cs.getCarTips(this.type).subscribe(
      (response) => {
        this.isLoading = false;
        // console.log(response.json());
        this.tips = response.json();
      },
      (error) => {
        // console.log(error);
      }
    );
  }

  ngOnInit() {
    this.getTips();
  }

}
