import {Input, Component, OnInit, Output, EventEmitter} from '@angular/core';
import {ConnectorService} from '../../../../../services/connector.service';

@Component({
  selector: 'app-select-system',
  templateUrl: './select-system.component.html',
  styleUrls: ['./select-system.component.css']
})
export class SelectSystemComponent implements OnInit {
  @Input() type;
  public _systemName;

  @Input()
  set value(value) {
    if(value){
      this._systemName = value;
      this.getSystems();
    }
  }

  public isLoading;
  public systems;
  @Output() onSystemSelected = new EventEmitter<any>();

  constructor(public cs: ConnectorService) {
  }

  onSelectSystems(system) {
    // console.log(system);
    this.onSystemSelected.emit(system);
  }

  getSystems() {
    this.isLoading = true;
    this.cs.getCarSystems(this.type).subscribe(
      (response) => {
        this.isLoading = false;
        this.systems = response.json();
        // console.log(response.json());
      },
      (error) => {
        // console.log(error);
      }
    );
  }

  ngOnInit() {
    this.getSystems();
  }

}
