import {Component, EventEmitter, Input, OnInit, Output} from '@angular/core';
import {ConnectorService} from '../../../../../services/connector.service';

@Component({
  selector: 'app-select-colors',
  templateUrl: './select-colors.component.html',
  styleUrls: ['./select-colors.component.css']
})
export class SelectColorsComponent implements OnInit {
  public colors;
  @Output() onSelectColor = new EventEmitter<any>();
  public _selectedColor;

  get value() {
    return this._selectedColor;
  }

  @Input()
  set value(value) {
    // console.log('fasfsdfsfasfsadsafsafasdadfkasjldfo;', value);
    this._selectedColor = value;
  }

  constructor(public cs: ConnectorService) {
  }

  onSelectColor1(color) {
    this.onSelectColor.emit(color.source.value);
  }

  getColors() {
    this.cs.getColors().subscribe(
      (response) => {
        // console.log(response.json());
        this.colors = response.json();
      },
      (error) => {
        // console.log(error);
      }
    );
  }

  ngOnInit() {
    this.getColors();
  }

}
