import {Component, Input, SimpleChanges, AfterViewInit, Output, EventEmitter} from '@angular/core';
import {ActivatedRoute, Router} from '@angular/router';


@Component({
  selector: 'app-pagination',
  templateUrl: './pagination.component.html',
  styleUrls: ['./pagination.component.css']
})

export class PaginationComponent implements AfterViewInit {
  @Input() totalPages: any;
  public currentPage = 1;
  public visiblePages = [];
  public maxVisiblePages = 5;
  @Output() pageChanged = new EventEmitter();

  constructor(public route: ActivatedRoute,
              public router: Router) {
  }

  ngOnChanges(changes: SimpleChanges) {
    this.totalPages = changes.totalPages.currentValue;
    this.visiblePages = [];
    this.makeVisiblePages();
  }

  makeVisiblePages() {
    this.visiblePages = [];

    const currentPage = Number(this.currentPage);
    let startPage = 1;
    let endPage = this.totalPages;
    const maxSize = this.maxVisiblePages;


    if (this.totalPages <= maxSize) {
      startPage = 1;
      endPage = this.totalPages;
    } else {
      if (currentPage <= Math.floor(maxSize / 2)) {
        startPage = 1;
        endPage = maxSize;
      }
      else if (currentPage + Math.floor(maxSize / 2) >= this.totalPages) {
        startPage = this.totalPages - Math.floor(maxSize / 2) - 2;
        endPage = this.totalPages;
      } else {
        startPage = currentPage - Math.floor(maxSize / 2);
        endPage = currentPage + Math.floor(maxSize / 2);
      }
    }

    for (let i = startPage; i <= endPage; i++) {
      this.visiblePages.push(i);
    }

  }

  pageChange(i) {
    this.currentPage = i;
    const isValidPage = this.currentPage <= this.totalPages && 0 < this.currentPage;

    if (isValidPage) {
      this.pageChanged.emit(i);
      this.makeVisiblePages();
    }
  }

  nextPage() {
    this.pageChange(Number(this.currentPage) + 1);
  }

  previosPage() {
    this.pageChange(this.currentPage - 1);
  }

  ngAfterViewInit() {
    this.route.queryParams.subscribe(
      (params) => {
        this.currentPage = params.page !== undefined ? params.page : '1';
        this.makeVisiblePages();
      }
    );
  }

}

