import {Component, EventEmitter, Input, OnInit, Output, ViewChild} from '@angular/core';
import {AppService} from '../../../../services/app.service';
import * as moment from 'jalali-moment';

@Component({
  selector: 'app-material-date-time-picker-filed',
  templateUrl: './material-date-time-picker-filed.component.html',
  styleUrls: ['./material-date-time-picker-filed.component.css']
})
export class MaterialDateTimePickerFiledComponent implements OnInit {
  @Input() placeHolder;
  @Output() onReadyTimeStamp: EventEmitter<any> = new EventEmitter();
  @Input() mode = 'daytime';

  // @Input() defaultTime;
  @ViewChild('datePicker') datePicker;
  public date;
  datePickerConfig = {
    format: 'YYYY/M/D HH:mm'
  };

  _defaultTime: any;
  get defaultTime(): any {
    return this._defaultTime;
  }

  @Input('defaultTime')
  set defaultTime(value: any) {
    this._defaultTime = value;
    this.setDefaultTime();
  }

  constructor(public app: AppService) {
  }


  setDefaultTime() {
    if (this.defaultTime === 'now') {
      const jalaiDate = this.app.mdstimstampToJalali();
      this.date = moment(jalaiDate.toString(), 'jYYYY/jMM/jD HH:mm').format('jYYYY/jMM/jD HH:mm');
      return;
    }
    if (!this.defaultTime) {
      this.date = null;
      return;
    }
    const jalaiDate = this.app.mdstimstampToJalali(this.defaultTime * 1000);
    this.date = moment(jalaiDate.toString(), 'jYYYY/jMM/jD HH:mm').format('jYYYY/jMM/jD HH:mm');
  }


  resetDate() {
    this.date = '';
    this.onReadyTimeStamp.emit('');
  }

  onDateSelected(val) {
    if (!val) {
      return;
    }
    const timestamp = new Date(val).getTime();
    this.onReadyTimeStamp.emit(timestamp / 1000);
  }

  ngOnInit() {
    this.setDefaultTime();
    if (this.mode !== 'daytime') {
      this.datePickerConfig.format = 'YYYY/M/D ';
    }
  }

}
