import {Component, ElementRef, EventEmitter, Input, OnDestroy, Output} from '@angular/core';
import {FocusMonitor} from '@angular/cdk/a11y';
import {coerceBooleanProperty} from '@angular/cdk/coercion';
import {FormBuilder, FormGroup} from '@angular/forms';
import {MatFormFieldControl} from '@angular/material';
import {Subject} from 'rxjs';

export class MyTel {
  constructor(public area: any, public exchange: any) {
  }
}

@Component({
  selector: 'app-shomare-dasti',
  templateUrl: './shomare-dasti.component.html',
  styleUrls: ['./shomare-dasti.component.css'],
  providers: [{provide: MatFormFieldControl, useExisting: ShomareDastiComponent}],
  host: {
    '[class.floating]': 'shouldLabelFloat',
    '[id]': 'id',
    '[attr.aria-describedby]': 'describedBy',
  }
})

export class ShomareDastiComponent implements MatFormFieldControl<any>, OnDestroy {
  static nextId = 0;
  parts: FormGroup;
  @Output() onDastiChanged: EventEmitter<any> = new EventEmitter();
  stateChanges = new Subject<void>();

  focused = false;

  ngControl = null;

  errorState = false;

  controlType = 'my-tel-input';

  get empty() {
    let n = this.parts.value;
    return !n.area && !n.exchange && !n.subscriber;
  }

  get shouldLabelFloat() {
    return this.focused || !this.empty;
  }

  id = `my-tel-input-${ShomareDastiComponent.nextId++}`;

  describedBy = '';

  @Input()
  get placeholder() {
    return this._placeholder;
  }

  set placeholder(plh) {
    this._placeholder = plh;
    this.stateChanges.next();
  }

  private _placeholder: string;

  @Input()
  get required() {
    return this._required;
  }

  set required(req) {
    this._required = coerceBooleanProperty(req);
    this.stateChanges.next();
  }

  private _required = false;

  @Input()
  get disabled() {
    return this._disabled;
  }

  set disabled(dis) {
    this._disabled = coerceBooleanProperty(dis);
    this.stateChanges.next();
  }

  private _disabled = false;

  @Input()
  get value(): MyTel | null {
    let n = this.parts.value;
    // console.log(n);
    return null;
  }

  set value(pelak) {
    if (pelak) {
      const partOne = pelak.toString().substring(0, 2);
      const partTwo = pelak.toString().substring(2, 6);
      // const partThree = pelak.toString().substring(3, 6);
      // const partFour = pelak.toString().substring(6);
      this.parts.setValue({area: partOne, exchange: partTwo});
      this.stateChanges.next();
    }

  }

  constructor(fb: FormBuilder, private fm: FocusMonitor, private elRef: ElementRef) {
    this.parts = fb.group({
      'area': '',
      'exchange': '',
    });
    fm.monitor(elRef.nativeElement, true).subscribe((origin) => {
      this.focused = !!origin;
      this.stateChanges.next();
    });
    this.parts.valueChanges.subscribe(
      (val) => {
        // console.log(val);
        this.onDastiChanged.emit(val.area + val.exchange);
      }
    );
  }

  ngOnDestroy() {
    this.stateChanges.complete();
    this.fm.stopMonitoring(this.elRef.nativeElement);
  }


  setDescribedByIds(ids: string[]) {
    this.describedBy = ids.join(' ');
  }

  onContainerClick(event: MouseEvent) {
    if ((event.target as Element).tagName.toLowerCase() != 'input') {
      this.elRef.nativeElement.querySelector('input').focus();
    }
  }
}
