import {Component, OnInit} from '@angular/core';
import {ConnectorService} from '../../../../../services/connector.service';
import {Router} from '@angular/router';

@Component({
  selector: 'app-user-list',
  templateUrl: './user-list.component.html',
  styleUrls: ['./user-list.component.css']
})
export class UserListComponent implements OnInit {
  public userList;
  public numOfPages;
  public isLoading;
  public searchParams_name = '';
  public searchParams_code_melli = '';

  constructor(public cs: ConnectorService, public router: Router) {
  }

  getUserList(page) {
    this.isLoading = true;
    this.cs.searchInUsers(
      this.searchParams_name,
      this.searchParams_code_melli,
      page
    ).subscribe(
      (resposne) => {
        this.isLoading = false;
        console.log(resposne.json().users);
        this.userList = resposne.json().users;
        this.numOfPages = resposne.json().num_of_pages;
      },
      (error) => {
        console.log(error);
      }
    );

  }

  goToEditUser(id) {
    this.router.navigate(['/users/' + id]);
  }

  changePage(i) {
    this.getUserList(i);
  }

  ngOnInit() {
    this.getUserList(1);
  }

}
