import { Component, OnInit } from '@angular/core';
import { User } from '../../../../../interfaces';
import { ConnectorService } from '../../../../../services/connector.service';
import { Router, ActivatedRoute } from '@angular/router';

@Component({
  selector: 'app-single-user',
  templateUrl: './single-user.component.html',
  styleUrls: ['./single-user.component.css']
})
export class SingleUserComponent implements OnInit {
  userId: number;
  user = new User();

  constructor(public route: ActivatedRoute, public router: Router, public cs: ConnectorService) {
  }



  ;
  getUser() {
    this.cs.getUser(this.userId).subscribe(
      (response) => {
        console.log(response.json());
        this.user = response.json();
      },
      (error) => {
        console.log(error);
      });
  }
  editUser() {
    this.cs.editUser(this.userId, this.user)
      .subscribe(r => {
        console.log(r.json());
      })
  }

  ngOnInit() {
    this.route.params.subscribe(params => {
      this.userId = +params['id'];
      this.getUser();
    })
  }

}
