import {Component, OnInit} from '@angular/core';
import {ConnectorService} from '../../../../../services/connector.service';
import {User} from '../../../../../interfaces';
import {Router} from '@angular/router';

@Component({
  selector: 'app-create-user',
  templateUrl: './create-user.component.html',
  styleUrls: ['./create-user.component.css']
})
export class CreateUserComponent implements OnInit {
  public user = new User();

  constructor(public router: Router, public cs: ConnectorService) {

  }

  createUser() {
    console.log(this.user);
    this.cs.createUser(this.user).subscribe(
      (response) => {
        console.log(response);
        this.router.navigate(['/users/list/']);
      },
      (error) => {
        console.log(error);
      });
  }


  ngOnInit() {
  }

}
