import {Component, OnInit} from '@angular/core';
import {ActivatedRoute, Router} from '@angular/router';
import {ConnectorService} from '../../../../../services/connector.service';

@Component({
  selector: 'app-single-car',
  templateUrl: './single-car.component.html',
  styleUrls: ['./single-car.component.css']
})
export class SingleCarComponent implements OnInit {
  public carId;
  public car;

  constructor(public cs: ConnectorService, public route: ActivatedRoute, public router: Router) {
  }

  getCarInfo() {
    this.cs.getCar(this.carId).subscribe(
      (response) => {
        console.log(response.json());
        this.car = response.json();
      },
      (error) => {
        console.log(error);
      }
    ); }

  setColorDetails(colorDetails) {
    this.car.color_details = colorDetails;
    console.log(this.car.color_details);
  }

  setCarId() {
    this.carId = this.route.snapshot.params.id;
  }

  editCar() {
    this.cs.editCar(this.carId, this.car).subscribe(
      (response) => {
        console.log(response.json());
        this.router.navigate(['/parking/list/']);
      },
      (error) => {
        console.log(error);
      }
    );
  }

  ngOnInit() {
    this.setCarId();
    this.getCarInfo();
  }
}
