import {Component, OnInit} from '@angular/core';
import {ConnectorService} from '../../../../../../services/connector.service';
import {Cars, HistorySearchParams, UserInterface} from '../../../../../../interfaces';
import {MatDialog} from '@angular/material';

@Component({
  selector: 'app-parking-history-list',
  templateUrl: './parking-history-list.component.html',
  styleUrls: ['./parking-history-list.component.css']
})
export class ParkingHistoryListComponent implements OnInit {
  public cars: Cars[] = [];
  public numOfPages;
  public searchParams = new HistorySearchParams();

  constructor(public cs: ConnectorService, public dialog: MatDialog) {
  }

  getHistory() {
    this.cs.getParkingHistory(this.searchParams).subscribe(
      (response) => {
        console.log(response.json());
        const historyData = response.json();
        this.numOfPages = historyData.num_of_pages;
        this.cars = historyData.cars;
      },
      (error) => {
        console.log(error);
      }
    );
  }

  changePage(page) {
    this.searchParams.page = page;
    this.getHistory();
  }


  ngOnInit() {
    this.getHistory();
  }

  getN(gholname: { kharidar: UserInterface | null; foro0shande: UserInterface | null }[]) {
    if (gholname.length === 0) {
      return 'بدون خریدار و فروشنده';
    }
    let rs = [
      gholname[0].foro0shande.first_name + ' ' + gholname[0].foro0shande.last_name
    ];
    for (const g of gholname) {
      if (g.kharidar !== null) {
        rs.push(
          g.kharidar.first_name + ' ' + g.kharidar.last_name
        );
      }
    }
    return rs.join('->');
  }
}
