import {Component, Input, OnInit} from '@angular/core';
import {ConnectorService} from '../../../../../services/connector.service';

@Component({
  selector: 'app-parking-cars-list',
  templateUrl: './parking-cars-list.component.html',
  styleUrls: ['./parking-cars-list.component.css']
})
export class ParkingCarsListComponent implements OnInit {
  public numOfPages;
  public carsList;
  public isLoading;
  @Input() searchParams;

  constructor(public cs: ConnectorService) {
  }

  getParkingCars() {
    this.isLoading = true;
    this.cs.getCars(this.searchParams)
      .subscribe(
        (response) => {
          this.isLoading = false;
          console.log(response.json());
          this.carsList = response.json().cars;
          this.numOfPages = response.json().num_of_pages;
        },
        (error) => {
          console.log(error);
        }
      );
  }

  changePage(i) {
    this.searchParams.page = i;
    this.getParkingCars();
  }

  ngOnInit() {
    this.getParkingCars();
  }

}
