import {Component, Input, OnInit} from '@angular/core';
import {ConnectorService} from '../../../../../services/connector.service';
import {expens} from '../../../../../interfaces';

@Component({
  selector: 'app-expenses',
  templateUrl: './expenses.component.html',
  styleUrls: ['./expenses.component.css'],
})
export class ExpensesComponent implements OnInit {
  @Input() carId;
  public expensesList;
  public newExpens = new expens();

  constructor(public cs: ConnectorService) {

  }

  removeCost(id) {
    this.cs.removeCost(id).subscribe(
      (response) => {
        console.log(response.json());
        this.getExpenseses()
      },
      (error) => {
        console.log(error);
      }
    );
  }

  getExpenseses() {
    this.cs.getCarExpenses(this.carId).subscribe(
      (response) => {
        console.log(response.json());
        this.expensesList = response.json();
      },
      (error) => {
        console.log(error);
      }
    );
  }

  createExpens() {
    this.cs.createExpenses(this.newExpens).subscribe(
      (response) => {
        console.log(response);
        this.getExpenseses();
      },
      (error) => {
        console.log(error);
      }
    );
  }

  ngOnInit() {
    this.newExpens.car_id = this.carId;
    this.getExpenseses();
  }

}
