import {Component, EventEmitter, Input, OnInit, Output, ViewEncapsulation} from '@angular/core';

@Component({
  selector: 'app-car-color-information',
  templateUrl: './car-color-information.component.html',
  styleUrls: ['./car-color-information.component.css'],
  encapsulation: ViewEncapsulation.None
})
export class CarColorInformationComponent implements OnInit {
  @Input() colorDetails;
  @Output() onColorChange: EventEmitter<any> = new EventEmitter<any>();

  constructor() {
  }


  changeStatusOfColor(part) {
    const newValue = this.colorDetails[part] == '0' ? '1' : '0';
    this.colorDetails = this.colorDetails.substr(0, part) + newValue + this.colorDetails.substr(part + 1);
    this.onColorChange.emit(this.colorDetails);
  }

  ngOnInit() {
  }

}
