import {Component, OnInit, HostListener, ViewChild, Output} from '@angular/core';
import {environment} from '../../../../environments/environment';
import {MatSidenav} from '@angular/material';

@Component({
  selector: 'app-panel',
  templateUrl: './panel.component.html',
  styleUrls: ['./panel.component.css']
})
export class PanelComponent implements OnInit {
  @ViewChild('drawer') drawer: MatSidenav;

  constructor() {
  }

  isLargeScreen() {
    const width = window.innerWidth || document.documentElement.clientWidth || document.body.clientWidth;
    if (width > environment.maxSmallSize) {
      return true;
    } else {
      return false;
    }
  }

  closeSideNav(isLargeScreen) {
    if (!isLargeScreen) {
      this.drawer.close();
    }

  }

  @HostListener('window:resize', ['$event'])
  onResize(event) {
    // if (event.target.innerWidth < 600) {
    //   this.isDeviceMobile = true;
    // } else {
    //   this.isDeviceMobile = false;
    // }
  }

  ngOnInit() {

  }

}
