import {Component, OnInit} from '@angular/core';
import {ConnectorService} from '../../../../../services/connector.service';

@Component({
  selector: 'app-tarife-bank',
  templateUrl: './tarife-bank.component.html',
  styleUrls: ['./tarife-bank.component.css']
})
export class TarifeBankComponent implements OnInit {
  public name = '';
  public banks: any[] = [];

  constructor(private cs: ConnectorService) {
  }

  ngOnInit() {
    this.cs.getBanks().subscribe(
      (b) => {
        this.banks = b.json();
      }
    );
  }

  newBank() {
    this.cs.newBank(this.name).subscribe(
      (res) => {
        this.banks.push(res.json());
        this.name = '';
      }
    );
  }
}
