import {Component, Injector, OnInit} from '@angular/core';
import {SearchUsersComponent} from '../../../../shared/templates/search-users/search-users.component';
import {MAT_DIALOG_DATA, MatDialog, MatDialogRef} from '@angular/material';
import {TalBed} from '../../../../../interfaces';
import {ConnectorService} from '../../../../../services/connector.service';
import {Router} from '@angular/router';

@Component({
  selector: 'app-talabkar',
  templateUrl: './talabkar.component.html',
  styleUrls: ['./talabkar.component.css']
})
export class TalabkarComponent implements OnInit {
  shaks: any;
  data: TalBed = {
    id: null,
    shaks_id: null,
    babat: null,
    amount: null,
    num: null,
    qnum: 1,
    num_type: null,
    tarikh_daryaft: null,
    tarikh_sabt: null,
    tozihat: null
  };
  hasSar: string = '0';
  public outer_data: any = null;
  sabt_time: any = null;
  sarresid_time: any = null;
  private dialogRef: MatDialogRef<any>;

  constructor(public dialog: MatDialog, private injector: Injector, private cs: ConnectorService, private r: Router) {

    this.outer_data = this.injector.get(MAT_DIALOG_DATA, null);
    if (this.outer_data !== null) {
      this.dialogRef = this.injector.get(MatDialogRef);
    }
  }

  ngOnInit() {
    if (this.outer_data !== null) {
      this.cs.getTalab(this.outer_data.id).subscribe(
        (res) => {
          const resp = res.json();
          let td = null;
          this.hasSar = '0';
          if (resp.tarikh_daryaft !== null) {
            td = +resp.tarikh_daryaft;
            this.hasSar = '1';
          }
          this.sabt_time = resp.tarikh_sabt;
          this.sarresid_time = td;
          this.shaks = resp.shakhs;
          this.data = {
            id: resp.id,
            shaks_id: resp.shakhs.id,
            babat: resp.babat,
            qnum: +resp.qnum,
            amount: resp.amount,
            num: resp.talabbedehghest_set.length,
            num_type: resp.num_type ? '1' : '0',
            tarikh_daryaft: td,
            tarikh_sabt: +resp.tarikh_sabt,
            tozihat: resp.tozihat
          };
          console.log(this.hasSar);
        }
      );
    }
  }

  selectShakhs() {
    const userModal = this.dialog.open(SearchUsersComponent);
    userModal.afterClosed().subscribe(
      (user) => {
        console.log(user.data.id);
        this.shaks = user.data;
        this.data.shaks_id = user.data.id;
      }
    );
  }

  accept(refresh: boolean) {
    this.cs.createTalabkar(this.data).subscribe(
      () => {
        if (this.outer_data !== null) {
          this.dialogRef.close();
        } else {
          if (refresh) {
            this.reset();
          } else {
            this.r.navigate(['../hesabdari']);
          }
        }
      }
    );
  }

  reset() {
    this.shaks = null;
    this.sabt_time = null;
    this.hasSar = '0';
    this.sarresid_time = null;
    this.data = {
      shaks_id: null,
      qnum: 1,
      id: null,
      babat: null,
      amount: null,
      num: null,
      num_type: null,
      tarikh_sabt: null,
      tarikh_daryaft: null,
      tozihat: null
    };
  }

}
