import { Component, OnInit } from '@angular/core';
import { ConnectorService } from '../../../../../services/connector.service';
import { MatDialogRef } from '@angular/material';
import {AppService} from '../../../../../services/app.service';

@Component({
  selector: 'app-select-check',
  templateUrl: './select-check.component.html',
  styleUrls: ['./select-check.component.css']
})
export class SelectCheckComponent implements OnInit {

  constructor(public cs: ConnectorService, public dialog: MatDialogRef<any>, public app: AppService) {
  }

  public bank;
  public banks = [];
  public shomare_chek;
  public dar_vajh;
  public code;
  public shobe;
  public shomare_hesab;
  public saheb_hesab;
  public mablagh;

  public isLoading;
  public searchResult = [];
  public numOfPages;

  searchInCheks(page = 1) {
    this.isLoading = true;
    const s: {[key: string]: any} = {
      'page': page,
      'for_daryafti': 1
    };

    if (this.bank) {
      s['bank'] = this.bank;
    }

    if (this.shomare_chek) {
      s['shomare_chek'] = this.shomare_chek;
    }

    if (this.dar_vajh) {
      s['dar_vajh'] = this.dar_vajh;
    }

    if (this.code) {
      s['code'] = this.code;
    }

    if (this.shobe) {
      s['shobe'] = this.shobe;
    }

    if (this.shomare_hesab) {
      s['shomare_hesab'] = this.shomare_hesab;
    }

    if (this.saheb_hesab) {
      s['saheb_hesab'] = this.saheb_hesab;
    }

    console.log(s);
    this.cs.getChekList(s).subscribe(
      (response) => {
        this.isLoading = false;
        this.searchResult = response.json().data;
        this.numOfPages = response.json().num_of_pages;
      },
      (error) => {
        console.log(error);
      }
    );

  }

  changePage(i) {
    this.searchInCheks(i);
  }

  selectUser(user) {
    this.dialog.close({data: user});
  }

  ngOnInit() {
    this.searchInCheks(1);
    this.cs.getBanks()
      .subscribe(res => {
        this.banks = res.json();
      });
  }
}
