import {Component, OnInit} from '@angular/core';
import {MatDialog} from '@angular/material';
import {ConnectorService} from '../../../../../services/connector.service';
import {SearchUsersComponent} from '../../../../shared/templates/search-users/search-users.component';
import {DaryaftAzTarafHesabParams, Jahat, PardakhtBeTarafHesabParams} from '../../../../../interfaces';

interface Sandogh {
  is_daryaft: boolean;
  data: DaryaftAzTarafHesabParams | PardakhtBeTarafHesabParams;
}

@Component({
  selector: 'app-sandogh',
  templateUrl: './sandogh.component.html',
  styleUrls: ['./sandogh.component.css']
})
export class SandoghComponent implements OnInit {
  tavassot;
  user;
  numOfPages = 0;
  isLoading = false;
  sandoghList: Sandogh[] = [];
  jahats = {};
  searchParams = {
    page: 1,
    tavasot: '0',
    user: '0',
    from: '0',
    to: '0',
    type: '0',
  };
  public total: number = null;

  constructor(public dialog: MatDialog, private cs: ConnectorService) {
    this.jahats[Jahat.kharidKhodro.toString()] = 'خودرو';
    this.jahats[Jahat.hesabDaftari.toString()] = 'حساب دفتری';
    this.jahats[Jahat.daftarKol.toString()] = 'دفتر کل';
    this.jahats[Jahat.eslahieDaftarKol.toString()] = 'اضلاحیه دفتر کل';
    this.jahats[Jahat.eslahieHesabDaftaro.toString()] = 'اصلاحیه حساب دفتری';
    this.jahats[Jahat.faghatHesabDaftari.toString()] = 'فقط حساب دفتری';
  }

  selectUser(is_tavasot: boolean) {
    const userModal = this.dialog.open(SearchUsersComponent);
    userModal.afterClosed().subscribe(
      (user) => {
        console.log(user);
        if (is_tavasot) {
          this.tavassot = user.data;
          this.searchParams.tavasot = user.data.id;
        } else {
          this.user = user.data;
          this.searchParams.user = user.data.id;
        }
      }
    );
  }

  ngOnInit() {
    this.getAll();
  }


  getAll() {
    this.isLoading = true;
    this.cs.getSandogh(this.searchParams).subscribe(
      (res) => {
        const resp = res.json();
        this.sandoghList = resp.data;
        this.total = resp.total;
        this.numOfPages = resp.num_of_pages;
        this.isLoading = false;
      }
    );
  }

  reset() {
    this.searchParams = {
      page: 1,
      tavasot: '0',
      user: '0',
      from: '0',
      to: '0',
      type: '0',
    };
    this.sandoghList = [];
    this.tavassot = null;
    this.user = null;
    this.total = null;
    this.numOfPages = 1;
  }
}
