import {Component, Injector, OnInit} from '@angular/core';
import {MAT_DIALOG_DATA, MatDialog, MatDialogRef, MatSelectChange} from '@angular/material';
import {SearchUsersComponent} from '../../../../shared/templates/search-users/search-users.component';
import {DaftarKol, GhestOfHesabDaftari, HesabDaftarKol, Jahat, PardakhtBeTarafHesabParams} from '../../../../../interfaces';
import {ConnectorService} from '../../../../../services/connector.service';
import {SelectCheckComponent} from '../select-check/select-check.component';
import {Router} from '@angular/router';
import {NgxPersianNumbersService} from 'ngx-persian-number/src/services/ngx-persian-numbers.service';
import {AppService} from '../../../../../services/app.service';
import {hasOwnProperty} from 'tslint/lib/utils';

@Component({
  selector: 'app-pardakht-be-taraf-hesab',
  templateUrl: './pardakht-be-taraf-hesab.component.html',
  styleUrls: ['./pardakht-be-taraf-hesab.component.css']
})
export class PardakhtBeTarafHesabComponent implements OnInit {
  pardakhtkonande: any;
  tavassot: any;
  data: PardakhtBeTarafHesabParams = {
    id: null,
    daryaft_konande_id: null,
    tavassot_id: null,
    tarikh_daryaft: null,
    jahat: null,
    babat: null,
    tozihat: null,
    daftar_kol_id: null,
    hesab_daftar_kol_id: null,
    pos_amount: null,
    card_amount: null,
    cash_amount: null,
    carmozd: null,
    cheks: [],
    ashkhas_cheks: []
  };
  ashkhas_cheks = [];
  jahatOptions = [
    {
      key: 'فروش خودرو',
      value: Jahat.kharidKhodro
    },
    {
      key: 'حساب دفتری',
      value: Jahat.hesabDaftari
    },
    {
      key: 'دفتر کل',
      value: Jahat.daftarKol
    },
    {
      key: 'اضلاحیه دفتر کل',
      value: Jahat.eslahieDaftarKol
    },
    {
      key: 'اصلاحیه حساب دفتری',
      value: Jahat.eslahieHesabDaftaro
    },
    {
      key: 'فقط حساب دفتری',
      value: Jahat.faghatHesabDaftari
    }
  ];
  daftarKolls: DaftarKol[];
  hesabDaftarKolls: any[] = [];
  chekHesabDaftarKolls: HesabDaftarKol[] = [];
  banks: any[] = [];
  pos: boolean = false;
  card: boolean = false;
  public outer_data: any = null;
  tahvil_date: any = null;
  ghest_data: GhestOfHesabDaftari = null;
  private dialogRef: MatDialogRef<any>;

  constructor(
    public dialog: MatDialog,
    private cs: ConnectorService,
    private r: Router,
    private ngxNum: NgxPersianNumbersService,
    public app: AppService,
    private injector: Injector,
  ) {
    this.outer_data = this.injector.get(MAT_DIALOG_DATA, null);
    if (this.outer_data !== null) {
      this.dialogRef = this.injector.get(MatDialogRef);
    }
  }

  selectChek(chek_index: number, val: MatSelectChange) {
    this.data.cheks[chek_index].bank_id = val.value.bank.id;
    this.data.cheks[chek_index].bank = val.value.bank;
    this.data.cheks[chek_index].code = val.value.code_shobe;
    this.data.cheks[chek_index].hesab = val.value.shomare_hesab;
    this.data.cheks[chek_index].shobe = val.value.shobe;
    this.data.cheks[chek_index].sub_hesab = val.value.saheb_hesab;
  }

  total() {
    let t = 0;
    if (this.data.pos_amount) {
      t += +this.data.pos_amount.toString().replace(/,/g, '');
    }
    if (this.data.card_amount) {
      t += +this.data.card_amount.toString().replace(/,/g, '');
    }
    if (this.data.cash_amount) {
      t += +this.data.cash_amount.toString().replace(/,/g, '');
    }
    for (const q of this.data.cheks) {
      if (q.amount === null) {
        continue;
      }
      t += +q.amount.toString().replace(/,/g, '');
    }
    for (const q of this.ashkhas_cheks) {
      if (q.amount === null) {
        continue;
      }
      t += +q.amount.toString().replace(/,/g, '');
    }
    return t;
  }

  selectPardakhtkonande() {
    const userModal = this.dialog.open(SearchUsersComponent);
    userModal.afterClosed().subscribe(
      (user) => {
        console.log(user.data.id);
        this.pardakhtkonande = user.data;
        this.data.daryaft_konande_id = user.data.id;
      }
    );
  }

  selectDaryaftKonande() {
    const userModal = this.dialog.open(SearchUsersComponent);
    userModal.afterClosed().subscribe(
      (user) => {
        console.log(user.data.id);
        this.tavassot = user.data;
        this.data.tavassot_id = user.data.id;
      }
    );
  }

  getDafatarKolHesabs() {
    const id = this.data.daftar_kol_id;
    const daftarKoll = this.daftarKolls.find(function (el) {
      return el.id === id;
    });
    this.hesabDaftarKolls = daftarKoll.hesabdaftarkol_set;
  }

  getDafatarKolHesab() {
    const id = this.data.hesab_daftar_kol_id;
    const hesabDaftarKoll = this.hesabDaftarKolls.find(function (el) {
      return el.id === id;
    });
    this.card = hesabDaftarKoll.has_card;
    this.pos = hesabDaftarKoll.has_pos;
  }

  setTahvilTime(e) {
    this.data.tarikh_daryaft = e;
  }

  selectCheck() {
    this.data.cheks.push({
      bank: null,
      bank_id: null,
      hesab: null,
      dar_vajh: null,
      number: null,
      code: null,
      shobe: null,
      sub_hesab: null,
      tarikh: null,
      amount: null,
    });
  }

  selectOtherChecks() {
    const chekModal = this.dialog.open(SelectCheckComponent);
    chekModal.afterClosed().subscribe(
      (chek) => {
        if (this.data.ashkhas_cheks.indexOf(chek.data.id) !== -1) {
          return;
        }
        this.ashkhas_cheks.push(chek.data);
        this.data.ashkhas_cheks.push(chek.data.id);
      }
    );
  }

  removeChek(i) {
    this.data.ashkhas_cheks.splice(i, 1);
    this.ashkhas_cheks.splice(i, 1);
  }

  ngOnInit() {
    Promise.all([
      this.cs.getDaftarKolls().toPromise(),
      this.cs.getHesabDaftarKols(true).toPromise(),
      this.cs.getBanks().toPromise(),
    ]).then((a) => {
      this.daftarKolls = a[0].json();
      this.chekHesabDaftarKolls = a[1].json();
      this.banks = a[2].json();
      if (this.outer_data !== null) {
        if (hasOwnProperty(this.outer_data, 'id')) {
          this.set_data();
        } else {
          this.set_data2();
        }
      }
    });
  }

  set_data() {
    this.cs.getPardakht(this.outer_data.id).subscribe(
      (res) => {
        const resp = res.json();
        this.pardakhtkonande = resp.daryaft_konande;
        this.tavassot = resp.tavassot;
        this.tahvil_date = +resp.tarikh_pardakht;
        this.data = {
          id: resp.id,
          daryaft_konande_id: resp.daryaft_konande.id,
          tavassot_id: resp.tavassot.id,
          tarikh_daryaft: +resp.tarikh_pardakht,
          jahat: <Jahat>resp.jahat,
          babat: resp.bAbat,
          tozihat: resp.tozihat,
          daftar_kol_id: resp.hesab_daftar_kol.daftar_kol.id,
          hesab_daftar_kol_id: resp.hesab_daftar_kol.id,
          pos_amount: resp.pos_amount,
          card_amount: resp.card_amount,
          cash_amount: resp.cash,
          carmozd: resp.carmozd,
          cheks: [],
          ashkhas_cheks: []
        };
        this.getDafatarKolHesabs();
        this.getDafatarKolHesab();
      }
    );
  }

  set_data2() {
    this.ghest_data = this.outer_data['sandogh'];
    this.tavassot = this.ghest_data.talab_bedeh.shakhs;
    this.data.tavassot_id = this.ghest_data.talab_bedeh.shakhs.id;
    this.data.jahat = Jahat.hesabDaftari;
  }

  send() {
    this.data.card_amount = +this.ngxNum.removeLettersFromString(this.data.card_amount);
    this.data.cash_amount = +this.ngxNum.removeLettersFromString(this.data.cash_amount);
    this.data.pos_amount = +this.ngxNum.removeLettersFromString(this.data.pos_amount);
    this.data.carmozd = +this.ngxNum.removeLettersFromString(this.data.carmozd);
    for (let i of this.data.cheks) {
      i.amount = +this.ngxNum.removeLettersFromString(i.amount);
    }
    if (this.ghest_data !== null) {
      if (this.total() > this.ghest_data.amount) {
        return;
      }
      this.data['ghest_data'] = this.ghest_data.id;
    }
    this.cs.createPardakhtBeTarafHesab(this.data).subscribe(
      () => {
        if (this.outer_data !== null) {
          this.dialogRef.close();
        } else {
          this.r.navigate(['../hesabdari']);
        }
      }
    );
  }
}
