import {Component, OnInit} from '@angular/core';
import {MinimalHesab} from '../../../../../interfaces';
import {ActivatedRoute} from '@angular/router';
import {ConnectorService} from '../../../../../services/connector.service';
import {MatDialog} from '@angular/material';
import {SearchUsersComponent} from '../../../../shared/templates/search-users/search-users.component';
import {PardakhtBeTarafHesabComponent} from '../pardakht-be-taraf-hesab/pardakht-be-taraf-hesab.component';
import {DaryaftAzTarafHesabComponent} from '../daryaft-az-taraf-hesab/daryaft-az-taraf-hesab.component';
import {BedehkarComponent} from '../bedehkar/bedehkar.component';
import {TalabkarComponent} from '../talabkar/talabkar.component';
import {ChekDialogComponent} from '../chek-dialog/chek-dialog.component';

@Component({
  selector: 'app-hesab-daftari',
  templateUrl: './hesab-daftari.component.html',
  styleUrls: ['./hesab-daftari.component.css']
})
export class HesabDaftariComponent implements OnInit {
  isLoading: boolean = false;
  // private id: number;
  public data: MinimalHesab[] = [];
  amel: any;
  tavasot: any;
  search = {
    az: null,
    no: '0',
    amel: null,
    tavasot: null,
    babat: '',
    tozihat: '',
    tarigh: '0',
  };
  // totalp = 0;
  // totaln = 0;
  name: string = '';
  hesabs: string = '';
  // yesterday: number = null;
  readonly type_of_txt: string[] = [
    ' پرداخت',
    'دریافت',
    'طلبکار',
    'بدهکار'
  ];
  public totalp: number = 0;
  public totaln: number = 0;

  constructor(
    private r: ActivatedRoute,
    private cs: ConnectorService,
    private dialog: MatDialog
  ) {
  }


  ngOnInit() {
  }

  changePage() {
    this.isLoading = true;
    const s = {};

    for (const i in this.search) {
      if (this.search[i] === null || this.search[i] === undefined || this.search[i] === '') {
        continue;
      }
      s[i] = this.search[i];
    }

    this.data = [];
    this.cs.getHesabDaftariDetail(s).subscribe(
      (res) => {
        let dt = res.json();

        const green_data: MinimalHesab[] = [];
        const red_data: MinimalHesab[] = [];

        if (this.search.no === '1') {
          dt = dt.filter((el) => {
            return el.sign;
          });
        } else if (this.search.no === '2') {
          dt = dt.filter((el) => {
            return !el.sign;
          });
        }

        const tarigh = +this.search.tarigh;
        const jomle = [
          'وصول چک به شماره ',
          'پاس چک به شماره '
        ];
        for (const i of dt) {
          const m = i.deleted ? red_data : (this.check(i.sarresid) ? green_data : this.data);
          if (i.pos_amount > 0 && (tarigh === 0 || tarigh === 1)) {
            m.push({
              id: i.id,
              tpl: i.tpl,
              amel: i.amel,
              tavassot: i.tavassot,
              bAbat: i.bAbat,
              sign: !i.sign,
              tozihat: i.tozihat,
              amount: i.pos_amount,
              pos_amount: 0,
              chek_amount: 0,
              cash_amount: 0,
              carmozd: 0,
              card_amount: 0,
              created_at: i.created_at,
              tarigh: i.tarigh,
              tarigh_txt: 'پوز',
              jahat: i.jahat,
              sarresid: i.sarresid,
              type_of: i.type_of,
              deleted: i.deleted
            });
          }
          if (i.cash_amount > 0 && (tarigh === 0 || tarigh === 3)) {
            m.push({
              id: i.id,
              tpl: i.tpl,
              amel: i.amel,
              tavassot: i.tavassot,
              bAbat: i.bAbat,
              sign: !i.sign,
              tozihat: i.tozihat,
              amount: i.cash_amount,
              pos_amount: 0,
              chek_amount: 0,
              cash_amount: 0,
              card_amount: 0,
              carmozd: 0,
              jahat: i.jahat,
              created_at: i.created_at,
              tarigh: i.tarigh,
              tarigh_txt: 'نقدی',
              sarresid: i.sarresid,
              type_of: i.type_of,
              deleted: i.deleted
            });
          }
          if (i.card_amount > 0 && (tarigh === 0 || tarigh === 2)) {
            m.push({
              id: i.id,
              tpl: i.tpl,
              amel: i.amel,
              tavassot: i.tavassot,
              bAbat: i.bAbat,
              sign: !i.sign,
              tozihat: i.tozihat,
              amount: i.card_amount,
              pos_amount: 0,
              cash_amount: 0,
              chek_amount: 0,
              card_amount: 0,
              carmozd: 0,
              created_at: i.created_at,
              tarigh: i.tarigh,
              tarigh_txt: 'کارت',
              jahat: i.jahat,
              sarresid: i.sarresid,
              type_of: i.type_of,
              deleted: i.deleted
            });
          }
          if (i.carmozd > 0) {
            m.push({
              id: i.id,
              tpl: i.tpl,
              amel: i.amel,
              tavassot: i.tavassot,
              bAbat: i.bAbat,
              sign: !i.sign,
              tozihat: i.tozihat,
              amount: i.carmozd,
              pos_amount: 0,
              cash_amount: 0,
              chek_amount: 0,
              card_amount: 0,
              carmozd: 0,
              created_at: i.created_at,
              tarigh: i.tarigh,
              tarigh_txt: 'کارمزد',
              jahat: i.jahat,
              sarresid: i.sarresid,
              type_of: i.type_of,
              deleted: i.deleted
            });
          }
          if (i.chek_amount > 0 && (tarigh === 0 || tarigh === 4)) {
            m.push({
              id: i.id,
              tpl: i.tpl,
              amel: i.amel,
              tavassot: i.tavassot,
              bAbat: jomle[i.sign ? 1 : 0] + i.bAbat,
              sign: i.sign,
              tozihat: i.tozihat,
              amount: i.chek_amount,
              pos_amount: 0,
              cash_amount: 0,
              chek_amount: 0,
              card_amount: 0,
              carmozd: 0,
              created_at: i.created_at,
              tarigh: i.tarigh,
              type_of: i.type_of,
              jahat: i.jahat,
              sarresid: i.sarresid,
              tarigh_txt: 'چک',
              deleted: i.deleted
            });
          }
        }
        for (const q of green_data) {
          this.data.unshift(q);
        }
        for (const q of red_data) {
          this.data.unshift(q);
        }
        // green_data = [];
        // red_data = [];

        this.totalp = this.data.reduce((total, dt) => {
          if (dt.deleted) {
            return total;
          }
          return total + (dt.sign ? 0 : dt.amount);
        }, 0);
        this.totaln = this.data.reduce((total, dt) => {
          if (dt.deleted) {
            return total;
          }
          return total + (dt.sign ? dt.amount : 0);
        }, 0);

        this.isLoading = false;
      }
    );
  }

  reset() {
    this.search = {
      az: null,
      no: '0',
      amel: null,
      tavasot: null,
      babat: '',
      tozihat: '',
      tarigh: '0',
    };
    this.amel = null;
    this.tavasot = null;
  }

  selectUser(is_amel: boolean) {
    const userModal = this.dialog.open(SearchUsersComponent);
    userModal.afterClosed().subscribe(
      (user) => {
        if (is_amel) {
          this.amel = user.data;
          this.search.amel = user.data.id;
        } else {
          this.tavasot = user.data;
          this.search.tavasot = user.data.id;
        }
      }
    );
  }

  check(sarresid: number[]) {
    return sarresid.length > 0 && sarresid[1] !== null;
  }

  update_record(sandogh: MinimalHesab) {
    let models = null;
    if (sandogh.tpl === 0) {
      models = PardakhtBeTarafHesabComponent;
    } else if (sandogh.tpl === 1) {
      models = DaryaftAzTarafHesabComponent;
    } else if (sandogh.tpl === 3) {
      models = ChekDialogComponent;
    } else if (sandogh.sign) {
      models = TalabkarComponent;
    } else {
      models = BedehkarComponent;
    }

    this.dialog.open(models, {
      data: {
        id: sandogh.id
      },
      width: '1000px',
      minHeight: '300px'
    }).afterClosed().subscribe(
      () => {
        this.changePage();
      }
    );
  }
}
